/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.Deserializer;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.log.file.LogReaderFilenameFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.jbpm.logging.log.ProcessLog;

public class ZipUtil {
    public static final String EXTENSION = ".zip";
    private static final Logger logger = Logger.getLogger(ZipUtil.class);

    public static void compress(File dir) throws IOException {
        ZipOutputStream os = ZipUtil.create(dir);
        ZipUtil.compress(os, dir);
        ZipUtil.close(os);
    }

    public static int count(File zip, long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) throws IOException {
        if (zip.length() == 0L) {
            return 0;
        }
        ZipFile zf = new ZipFile(zip);
        List<ZipEntry> zipEntryList = ZipUtil.filterFileName(LogReader.getSimpleNameList(types), nodeIds, Collections.list(zf.entries()));
        return zipEntryList.size();
    }

    public static List<ProcessLog> read(File zip) throws IOException {
        if (zip.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        ZipFile zf = new ZipFile(zip);
        for (ZipEntry zipEntry : Collections.list(zf.entries())) {
            InputStream is = zf.getInputStream(zipEntry);
            ProcessLog obj = new Deserializer(zipEntry.getName(), is).deserialize();
            if (obj != null) {
                list.add(obj);
            }
            is.close();
        }
        return list;
    }

    public static List<ProcessLog> read(File zip, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) throws IOException {
        if (zip.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        ZipFile zf = new ZipFile(zip);
        List<ZipEntry> zipEntryList = ZipUtil.filterFileName(LogReader.getSimpleNameList(types), nodeIds, Collections.list(zf.entries()));
        ZipUtil.sort(zipEntryList, descending);
        int end = zipEntryList.size() - start < count ? zipEntryList.size() : start + count;
        for (ZipEntry entry : zipEntryList.subList(start, end)) {
            InputStream is = zf.getInputStream(entry);
            ProcessLog log = new Deserializer(entry.getName(), is).deserialize();
            if (log != null) {
                list.add(log);
            }
            is.close();
        }
        return list;
    }

    public static String getZipFileName(File dir) {
        return dir.getAbsolutePath() + File.separator + dir.getName() + EXTENSION;
    }

    private static ZipOutputStream create(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory");
        }
        String name = ZipUtil.getZipFileName(dir);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(name));
        zos.setLevel(9);
        Logger.getLogger(ZipUtil.class).debug((Object)("Created zip file " + name));
        return zos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(ZipOutputStream out, File dir) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.getName().endsWith(EXTENSION)) continue;
            byte[] buffer = new byte[8192];
            InputStream in = null;
            try {
                int len;
                out.putNextEntry(new ZipEntry(file.getName()));
                in = new BufferedInputStream(new FileInputStream(file));
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                out.closeEntry();
            }
        }
    }

    private static void close(ZipOutputStream zos) {
        try {
            zos.close();
        }
        catch (IOException e) {
            logger.warn((Object)":(", (Throwable)e);
        }
    }

    private static List<ZipEntry> filterFileName(List<String> typeNames, Set<Long> nodeIds, List<ZipEntry> zipEntries) {
        ArrayList<ZipEntry> zipEntryList = new ArrayList<ZipEntry>();
        for (ZipEntry entry : zipEntries) {
            Pattern pattern = Pattern.compile(LogReaderFilenameFilter.getLogReaderFilenameRegex(typeNames), 2);
            Matcher matcher = pattern.matcher(entry.getName());
            while (matcher.find()) {
                if (!nodeIds.contains(Long.parseLong(matcher.group(1)))) continue;
                zipEntryList.add(entry);
            }
        }
        return zipEntryList;
    }

    private static void sort(List<ZipEntry> zipEntries, boolean descending) {
        if (descending) {
            Collections.sort(zipEntries, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry file1, ZipEntry file2) {
                    return file2.getName().compareTo(file1.getName());
                }
            });
        } else {
            Collections.sort(zipEntries, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry file1, ZipEntry file2) {
                    return file1.getName().compareTo(file2.getName());
                }
            });
        }
    }
}

