/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command.buffer;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.driver.command.buffer.ICommandBuffer;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.util.DefaultMessageKeyGenerator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jbpm.graph.exe.Token;

public class CommandBuffer
implements ICommandBuffer {
    private Collection<SoftReference<ICommand>> commands;
    private String uid;
    private Lock lock;
    private int discarded;

    public CommandBuffer(String uid) {
        this.uid = uid;
        this.commands = new ArrayList<SoftReference<ICommand>>();
        this.lock = new ReentrantLock();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public int getSize() {
        return this.commands.size();
    }

    @Override
    public int getDiscarded() {
        return this.discarded;
    }

    public void addCommand(ICommand command) {
        this.lock.lock();
        this.commands.add(new SoftReference<ICommand>(command));
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommand removeCommand(CustomToken token, Map<String, Object> parameters) {
        IMessageKey key = new DefaultMessageKeyGenerator().generate((Token)token);
        ICommand ret = null;
        this.lock.lock();
        try {
            Iterator<SoftReference<ICommand>> i = this.commands.iterator();
            while (i.hasNext()) {
                SoftReference<ICommand> ref = i.next();
                ICommand command = ref.get();
                if (command == null) {
                    i.remove();
                    ++this.discarded;
                    continue;
                }
                WorkflowMessage message = command.getMessage();
                if (!key.equals(message.getKey()) && !message.match(parameters)) continue;
                i.remove();
                ret = command;
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ICommand> removeCommands() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        this.lock.lock();
        try {
            Iterator<SoftReference<ICommand>> i = this.commands.iterator();
            while (i.hasNext()) {
                SoftReference<ICommand> ref = i.next();
                ICommand command = ref.get();
                if (command == null) {
                    i.remove();
                    ++this.discarded;
                    continue;
                }
                i.remove();
                commands.add(command);
            }
        }
        finally {
            this.lock.unlock();
        }
        return commands;
    }

    @Override
    public void flush() {
        this.commands.clear();
    }
}

