/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot.clusteredservices;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.boot.EngineDriverProperties;
import com.tandbergtv.workflow.driver.boot.clusteredservices.HistoryLoggingListener;
import com.tandbergtv.workflow.driver.internal.callable.ReadClusterProperties;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class HistoryLoggingManager {
    private static final Logger logger = Logger.getLogger(HistoryLoggingManager.class);
    private HistoryLoggingListener listener = null;
    private Properties properties = null;

    public HistoryLoggingManager() {
        this.init();
    }

    private void init() {
        this.properties = this.readProperties();
    }

    public void startServices() {
        try {
            com.hazelcast.core.Cluster cluster = Hazelcast.getCluster();
            this.listener = new HistoryLoggingListener(this.properties);
            cluster.addMembershipListener((MembershipListener)this.listener);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to instantiate HistoryLogging Services", (Throwable)e);
        }
        this.listener.startServices();
    }

    private Properties readProperties() {
        EngineDriverProperties props = new EngineDriverProperties();
        if (Cluster.isMaster()) {
            return props;
        }
        ISchedulerService scheduler = (ISchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        Future future = scheduler.schedule((Callable)new ReadClusterProperties());
        Properties properties = new Properties();
        try {
            properties = (Properties)future.get(30L, TimeUnit.SECONDS);
            for (Object name : properties.keySet()) {
                props.put(name, properties.get(name));
                logger.debug((Object)(name + "=" + properties.get(name)));
            }
            props.store();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get properties from master", (Throwable)e);
        }
        return props;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

