/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.SelectorExistsException;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.driver.template.event.TemplateEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvents;
import com.tandbergtv.workflow.driver.template.internal.ArchivalService;
import com.tandbergtv.workflow.driver.template.internal.Files;
import com.tandbergtv.workflow.driver.template.internal.TemplateDAO;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.ProcessState;

public class TemplateLoaderService
implements ITemplateLoaderService {
    private static final String SERVICE_NAME = "Template Loader Service";
    private TemplateDAO dao;
    private IArchivalService archiver;
    private ISchedulerService<Void> scheduler;
    private int max;
    private Collection<UnparsedTemplate> list;
    private static final Logger logger = Logger.getLogger(TemplateLoaderService.class);

    public TemplateLoaderService(Properties properties, SessionFactory factory) {
        this.max = Integer.parseInt(properties.getProperty("template.max.count"));
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".service");
        int size = Integer.parseInt(bundle.getString("template.cache.size"));
        String name = bundle.getString("template.cache.name");
        this.list = Collections.synchronizedList(new ArrayList());
        this.scheduler = new Scheduler("template", 1, 1);
        this.archiver = new ArchivalService(this.scheduler);
        this.dao = new TemplateDAO(factory, name, size);
    }

    @Override
    public List<String> getAllTemplateNames() {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateDAO.TemplateComparator(this.dao));
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (map.containsKey(name)) continue;
            map.put(name, template.getVersion());
            names.add(template.getFullName());
        }
        return names;
    }

    @Override
    public List<WorkflowTemplate> getAllTemplates() {
        return this.dao.findAll();
    }

    @Override
    public WorkflowTemplate getTemplate(Serializable id) {
        return this.dao.findByKey(id);
    }

    @Override
    public WorkflowTemplate getTemplateByFullName(String name) {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateDAO.TemplateComparator(this.dao));
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getFullName())) continue;
            return template;
        }
        return null;
    }

    @Override
    public WorkflowTemplate getTemplateByName(String name) {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateDAO.TemplateComparator(this.dao));
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    @Override
    public List<WorkflowTemplate> getLatestTemplates() {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateDAO.TemplateComparator(this.dao));
        ArrayList<WorkflowTemplate> list = new ArrayList<WorkflowTemplate>();
        HashSet<String> names = new HashSet<String>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (names.contains(name)) continue;
            names.add(name);
            list.add(template);
        }
        return list;
    }

    @Override
    public List<WorkflowTemplate> getPreviousVersions(WorkflowTemplate template) {
        LinkedList<WorkflowTemplate> templates = new LinkedList<WorkflowTemplate>();
        int version = template.getVersion();
        for (WorkflowTemplate t : this.getAllTemplates()) {
            if (!t.getName().equals(template.getName()) || t.getVersion() >= version) continue;
            templates.add(t);
        }
        return templates;
    }

    @Override
    public WorkflowTemplate getTemplateBySelectorKey(String selectorKey) {
        for (WorkflowTemplate template : this.getLatestTemplates()) {
            for (Selector selector : template.getSelectorKeys()) {
                if (!selector.getSelectionKey().equals(selectorKey)) continue;
                return template;
            }
        }
        throw new DriverRuntimeException("Failed to find template for selector key " + selectorKey);
    }

    @Override
    public void runCompiler(File file, ITemplateReader reader) {
        this.list.add(new UnparsedTemplate(file, reader));
    }

    @Override
    public void update(WorkflowTemplate template) throws DriverException {
        this.dao.update(template);
    }

    @Override
    public void delete(WorkflowTemplate template) throws DriverException {
        this.dao.delete(template);
    }

    @Override
    public void addSelector(Serializable id, Selector selector) throws DriverException {
        for (WorkflowTemplate t : this.getAllTemplates()) {
            for (Selector s : t.getSelectorKeys()) {
                if (!s.getSelectionKey().equals(selector.getSelectionKey())) continue;
                throw new SelectorExistsException("Key " + selector.getSelectionKey() + " is mapped to template " + t.getFullName());
            }
        }
        WorkflowTemplate template = this.getTemplate(id);
        if (template == null) {
            throw new DriverException("Failed to find template [" + id + "]");
        }
        template.addSelectorKey(selector);
        this.update(template);
    }

    @Override
    public void removeSelector(Serializable id, Selector selector) throws DriverException {
        WorkflowTemplate template = this.getTemplate(id);
        selector.setTemplate(template);
        template.removeSelectorKey(selector);
        this.update(template);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.getCache().start();
        this.scheduler.schedule((Callable)new CacheLoader());
        this.scheduler.schedule((Runnable)new CompilerTask(), 0L, 10000L);
    }

    public void stop() {
        this.getCache().stop();
        this.archiver.stop();
        this.scheduler.stop();
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    protected void save(File file, WorkflowTemplate template) throws DriverException {
        this.checkVersion(template);
        this.checkLicense(template);
        Files.unzipArchive(template, file);
        this.dao.create(template);
        this.archiver.run(template);
        if (!Files.success(file)) {
            logger.warn((Object)("Failed to move file " + file.getAbsolutePath()));
        }
    }

    private Collection<UnparsedTemplate> firstPass(Collection<UnparsedTemplate> files) {
        ArrayList<UnparsedTemplate> pending = new ArrayList<UnparsedTemplate>();
        for (UnparsedTemplate unparsed : files) {
            File file = unparsed.file;
            ITemplateReader reader = unparsed.reader;
            WorkflowTemplate template = null;
            try {
                template = reader.read();
                ReferenceChecker visitor = new ReferenceChecker();
                template.breadthFirstTraversal((NodeVisitor)visitor);
                if (visitor.hasReferences) {
                    pending.add(unparsed);
                    continue;
                }
                this.fireEvent(file, template, TemplateEvents.COMPILED);
                this.save(file, template);
            }
            catch (TemplateReaderException e) {
                if (e.hasUnresolvedReferences()) {
                    pending.add(unparsed);
                    continue;
                }
                this.die(file, template, (Exception)((Object)e));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to ingest template " + file.getAbsolutePath()), (Throwable)e);
                Files.reject(file);
            }
        }
        return pending;
    }

    private void secondPass(Collection<UnparsedTemplate> files) {
        for (UnparsedTemplate unparsed : files) {
            File file = unparsed.file;
            ITemplateReader reader = unparsed.reader;
            WorkflowTemplate template = null;
            try {
                template = reader.read();
                this.fireEvent(file, template, TemplateEvents.COMPILED);
                logger.debug((Object)template);
                this.save(file, template);
            }
            catch (TemplateReaderException e) {
                this.die(file, template, (Exception)((Object)e));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to ingest template " + file.getAbsolutePath()), (Throwable)e);
                Files.reject(file);
            }
        }
    }

    private ICacheService<WorkflowTemplate> getCache() {
        return this.dao.getCache();
    }

    private void checkLicense(WorkflowTemplate template) throws DriverException {
        int count = this.getLicenseCount();
        for (WorkflowTemplate t : this.getLatestTemplates()) {
            if (!t.getName().equals(template.getName())) continue;
            return;
        }
        if (this.getLatestTemplates().size() >= count) {
            throw new DriverException("License unavailable for template " + template.getFullName() + ", limit = " + count);
        }
    }

    private void checkVersion(WorkflowTemplate template) throws DriverException {
        WorkflowTemplate latest = this.getLatestTemplate(template.getName());
        if (latest != null && latest.getVersion() >= template.getVersion()) {
            throw new DriverException("Template " + template + " - version must exceed " + latest.getVersion());
        }
    }

    private WorkflowTemplate getLatestTemplate(String name) {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateDAO.TemplateComparator(this.dao));
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    private void die(File file, WorkflowTemplate template, Exception e) {
        logger.error((Object)("Failed to ingest template " + file.getAbsolutePath()), (Throwable)e);
        this.fireEvent(file, template, TemplateEvents.COMPILE_ERROR);
        Files.reject(file);
    }

    private void fireEvent(Object source, WorkflowTemplate template, TemplateEvents type) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent(source, template, type));
    }

    private int getLicenseCount() {
        return this.max;
    }

    private final class CacheLoader
    implements Callable<Void> {
        private CacheLoader() {
        }

        @Override
        public Void call() throws Exception {
            try {
                TemplateLoaderService.this.dao.load();
                logger.info((Object)("Loaded " + TemplateLoaderService.this.getCache().count() + " templates"));
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)TemplateLoaderService.this, ServiceEvents.STARTED));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to load templates", (Throwable)e);
            }
            TemplateLoaderService.this.archiver.start();
            return null;
        }
    }

    private final class CompilerTask
    implements Runnable {
        private CompilerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TemplateLoaderService.this.list.isEmpty()) {
                return;
            }
            logger.debug((Object)("Count is " + TemplateLoaderService.this.list.size()));
            ArrayList copy = null;
            Collection collection = TemplateLoaderService.this.list;
            synchronized (collection) {
                copy = new ArrayList(TemplateLoaderService.this.list);
                TemplateLoaderService.this.list.clear();
            }
            if (copy.isEmpty()) {
                return;
            }
            TemplateLoaderService.this.secondPass(TemplateLoaderService.this.firstPass(copy));
        }
    }

    private final class ReferenceChecker
    implements NodeVisitor {
        boolean hasReferences = false;

        private ReferenceChecker() {
        }

        public void visit(Node node) {
            if (node instanceof ProcessState) {
                this.hasReferences = true;
            }
        }
    }

    private final class UnparsedTemplate {
        File file;
        ITemplateReader reader;

        UnparsedTemplate(File file, ITemplateReader reader) {
            this.file = file;
            this.reader = reader;
        }
    }
}

