/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.allocation;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.AllocationUtility;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoundRobinResourceAllocationStrategy
implements ResourceAllocationStrategy {
    private Map<Long, List<Long>> allocationHistory = new HashMap<Long, List<Long>>();

    @Override
    public Resource allocateResource(ResourceGroup resourceGroup) {
        Resource allocatedResource = null;
        List<Long> groupAllocationHistory = this.allocationHistory.get(resourceGroup.getId());
        if (groupAllocationHistory == null) {
            groupAllocationHistory = new ArrayList<Long>();
            this.allocationHistory.put(resourceGroup.getId(), groupAllocationHistory);
        }
        for (Resource resource : resourceGroup.getResources()) {
            Long resourceId = resource.getId();
            if (!AllocationUtility.isResourceAvailable(resource) || groupAllocationHistory.contains(resourceId)) continue;
            allocatedResource = resource;
            break;
        }
        if (allocatedResource == null) {
            for (Long resourceId : groupAllocationHistory) {
                Resource resource = this.findResource(resourceGroup, resourceId);
                if (resource == null || !AllocationUtility.isResourceAvailable(resource)) continue;
                allocatedResource = resource;
                break;
            }
        }
        if (allocatedResource != null) {
            Long resourceId;
            resourceId = allocatedResource.getId();
            groupAllocationHistory.remove(resourceId);
            groupAllocationHistory.add(resourceId);
        }
        return allocatedResource;
    }

    private Resource findResource(ResourceGroup resourceGroup, long resourceId) {
        Resource match = null;
        for (Resource resource : resourceGroup.getResources()) {
            if (resource.getId() != resourceId) continue;
            match = resource;
            break;
        }
        return match;
    }
}

