/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IHandler;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DefaultSoapHandler
extends AbstractHandler
implements IHandler {
    private static final Logger LOGGER = Logger.getLogger(DefaultSoapHandler.class);
    private static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_ENVELOPE_TAG = "Envelope";
    private static final String SOAP_BODY_TAG = "Body";
    private static final String SOAP_PREFIX = "soapenv";
    private static final String SCHEMA_ATTR = "xml:xsd";
    private static final String SCHEMA_INSTANCE_ATTR = "xml:xsi";

    public DefaultSoapHandler() {
    }

    public DefaultSoapHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    @Override
    public IMessage process(IMessage msg) throws HandlerException {
        LOGGER.debug((Object)("Processing message: " + msg));
        String soapEnvelope = this.createSOAPEnvelope(msg.getPayload().getContent());
        HTTPMessage result = this.constructMessage(soapEnvelope, msg);
        LOGGER.debug((Object)("Processed Message: " + result));
        return result;
    }

    @Override
    public IMessage postProcess(IMessage msg) throws HandlerException {
        LOGGER.debug((Object)("Post processing message: " + msg));
        String response = this.removeSOAPEnvelope(msg.getPayload().getContent());
        HTTPMessage result = this.constructMessage(response, msg);
        LOGGER.debug((Object)("Post processed Response: " + msg));
        return result;
    }

    private HTTPMessage constructMessage(String content, IMessage originalMessage) {
        HTTPPayload payload = new HTTPPayload(content);
        HTTPAttachment attachment = null;
        if (originalMessage.getAttachment() != null) {
            Object attachContent = originalMessage.getAttachment().getContent();
            String attachType = originalMessage.getAttachment().getContentType();
            attachment = new HTTPAttachment(attachContent, attachType);
        }
        return new HTTPMessage(payload, attachment);
    }

    private String createSOAPEnvelope(String xmlString) throws HandlerException {
        try {
            Document soapDocument = XMLDocumentUtility.loadXml(xmlString, true);
            Element documentElement = soapDocument.getDocumentElement();
            Element envelope = soapDocument.createElementNS(SOAP_NAMESPACE, SOAP_ENVELOPE_TAG);
            envelope.setPrefix(SOAP_PREFIX);
            envelope.setAttribute(SCHEMA_ATTR, "http://www.w3.org/2001/XMLSchema");
            envelope.setAttribute(SCHEMA_INSTANCE_ATTR, "http://www.w3.org/2001/XMLSchema-instance");
            Element body = soapDocument.createElementNS(SOAP_NAMESPACE, SOAP_BODY_TAG);
            body.setPrefix(SOAP_PREFIX);
            body.appendChild(documentElement);
            envelope.appendChild(body);
            soapDocument.appendChild(envelope);
            return XMLDocumentUtility.convertToString(soapDocument);
        }
        catch (Exception ex) {
            String error = "Failed to create a SOAP Envelope around the XML message payload.";
            throw new HandlerException(error, ex);
        }
    }

    private String removeSOAPEnvelope(String xmlString) throws HandlerException {
        try {
            Document doc = XMLDocumentUtility.loadXml(xmlString, true);
            NodeList nodeList = doc.getElementsByTagNameNS(SOAP_NAMESPACE, SOAP_ENVELOPE_TAG);
            Element envelope = (Element)nodeList.item(0);
            nodeList = envelope.getElementsByTagNameNS(SOAP_NAMESPACE, SOAP_BODY_TAG);
            Element body = (Element)nodeList.item(0);
            nodeList = body.getChildNodes();
            doc.removeChild(envelope);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    doc.appendChild(nodeList.item(i));
                    break;
                }
                ++i;
            }
            return XMLDocumentUtility.convertToString(doc);
        }
        catch (Exception ex) {
            String error = "Failed to remove the SOAP Envelope around the XML message payload";
            throw new HandlerException(error, ex);
        }
    }
}

