/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.model.process.Activity;
import com.tandbergtv.workflow.api.model.process.Process;
import com.tandbergtv.workflow.api.model.process.Task;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.Variable;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

final class Converters {
    Converters() {
    }

    public static Function<Map<String, Object>, Process> forProcess() {
        return new Function<Map<String, Object>, Process>(){

            public Process apply(Map<String, Object> map) {
                Process entity = new Process();
                entity.setId(Converters.parseInteger(map, "id").toString());
                entity.setHref(Converters.parseString(map, "href"));
                entity.setCurrent(Converters.parseString(map, "current"));
                entity.setPriority(Converters.parseString(map, "priority"));
                entity.setStatus(Converters.parseString(map, "status"));
                entity.setRequestedStatus(Converters.parseString(map, "adminstatus"));
                entity.setTemplate(Converters.parseString(map, "template"));
                entity.setTemplateId(Converters.parseInteger(map, "templateId").toString());
                entity.setErrorMessage(Converters.parseString(map, "error"));
                entity.setErrorCategory(Converters.parseString(map, "errorType"));
                entity.setErrorDate(Converters.parseDate(map, "errorTime"));
                entity.setProviderId(Converters.parseString(map, "providerId"));
                entity.setTitleId(Converters.parseString(map, "titleId"));
                entity.setEndDate(Converters.parseDate(map, "end"));
                entity.setStartDate(Converters.parseDate(map, "start"));
                return entity;
            }
        };
    }

    public static Function<Map<String, Object>, Resource> forResource() {
        return new Function<Map<String, Object>, Resource>(){

            public Resource apply(Map<String, Object> map) {
                Resource entity = new Resource();
                entity.setId(Converters.parseInteger(map, "id").toString());
                entity.setName(Converters.parseString(map, "name"));
                entity.setHref(Converters.parseString(map, "href"));
                entity.setUserCount(Converters.parseInteger(map, "userCount"));
                entity.setAdminState(Converters.parseString(map, "adminState"));
                entity.setState(Converters.parseString(map, "operationalState"));
                entity.setResourceType(Converters.parseString(map, "resourceTypeName"));
                entity.setFunctionalType(Converters.parseString(map, "functionalType"));
                entity.setConcurrency(Converters.parseInteger(map, "maxConcurrentUsage"));
                entity.setUrl(Converters.parseString(map, "connectionString"));
                entity.setHeartbeatUrl(Converters.parseString(map, "heartbeatConnectionString"));
                entity.setHeartbeatFrequency(Converters.parseInteger(map, "heartbeatFrequency"));
                entity.setIgnoreTimeout(Converters.parseBoolean(map, "ignoreTimeOut"));
                List list = (List)map.get("resourceGroups");
                List groups = Lists.transform((List)list, Converters.forResourceGroup());
                entity.setGroups(groups);
                return entity;
            }
        };
    }

    public static Function<Map<String, Object>, ResourceGroup> forResourceGroup() {
        return new Function<Map<String, Object>, ResourceGroup>(){

            public ResourceGroup apply(Map<String, Object> map) {
                ResourceGroup entity = new ResourceGroup();
                entity.setId(Converters.parseInteger(map, "id").toString());
                entity.setName(Converters.parseString(map, "name"));
                entity.setHref(Converters.parseString(map, "href"));
                entity.setQueueSize(Converters.parseInteger(map, "queueSize"));
                entity.setResourceType(Converters.parseString(map, "resourceTypeName"));
                entity.setInternallyAcquired(Converters.parseBoolean(map, "isInternallyAcquired"));
                entity.setVisible(Converters.parseBoolean(map, "isVisible"));
                return entity;
            }
        };
    }

    public static Function<Map<String, Object>, Template> forTemplate() {
        return new Function<Map<String, Object>, Template>(){

            public Template apply(Map<String, Object> map) {
                List list;
                Template entity = new Template();
                entity.setId(Converters.parseString(map, "id"));
                entity.setName(Converters.parseString(map, "name"));
                entity.setHref(Converters.parseString(map, "href"));
                entity.setUuid(Converters.parseString(map, "uuid"));
                entity.setVersion(Converters.parseInteger(map, "version").toString());
                entity.setAnnotations(Converters.parseStringArray(map, "annotations"));
                entity.setSelectors(Converters.parseStringArray(map, "selectors"));
                entity.setProtectionKeys(Converters.parseStringArray(map, "protectionKeys"));
                List variables = (List)map.get("variables");
                if (variables != null && !variables.isEmpty()) {
                    entity.setVariables(Lists.transform((List)variables, Converters.forVariable()));
                }
                if ((list = (List)map.get("resourceGroups")) != null) {
                    entity.setGroups(Lists.transform((List)list, Converters.forResourceGroup()));
                }
                return entity;
            }
        };
    }

    public static Function<Map<String, Object>, Variable> forVariable() {
        return new Function<Map<String, Object>, Variable>(){

            public Variable apply(Map<String, Object> map) {
                Variable variable = new Variable();
                variable.setName(Converters.parseString(map, "name"));
                variable.setDisplayname(Converters.parseString(map, "displayname"));
                variable.setType(Converters.parseString(map, "type"));
                variable.setValue(Converters.parseString(map, "value"));
                variable.setRequired(Converters.parseBoolean(map, "required"));
                return variable;
            }
        };
    }

    public static Function<Map<String, Object>, Activity> forActivity() {
        return new Function<Map<String, Object>, Activity>(){

            public Activity apply(Map<String, Object> map) {
                Activity entity = new Activity();
                entity.setId(Converters.parseString(map, "id"));
                entity.setCurrent(Converters.parseString(map, "current"));
                entity.setPriority(Converters.parseString(map, "priority"));
                entity.setStatus(Converters.parseString(map, "status"));
                entity.setAdminStatus(Converters.parseString(map, "adminstatus"));
                entity.setTemplate(Converters.parseString(map, "template"));
                entity.setUsageStartDate(Converters.parseDate(map, "start"));
                entity.setResource(Converters.parseString(map, "resource"));
                entity.setResourceId(Converters.parseString(map, "resourceId").toString());
                entity.setProgress(Converters.parseString(map, "progress").toString());
                entity.setProviderId(Converters.parseString(map, "providerId"));
                entity.setTitleId(Converters.parseString(map, "titleId"));
                return entity;
            }
        };
    }

    public static Function<Map<String, Object>, Task> forTask() {
        return new Function<Map<String, Object>, Task>(){

            public Task apply(Map<String, Object> map) {
                Task entity = new Task();
                entity.setId(Converters.parseInteger(map, "id").toString());
                entity.setName(Converters.parseString(map, "name"));
                entity.setStart(Converters.parseDate(map, "start"));
                entity.setTaskId(Converters.parseInteger(map, "taskId").toString());
                entity.setTemplate(Converters.parseString(map, "template"));
                entity.setGroup(Converters.parseString(map, "group"));
                entity.setProviderId(Converters.parseString(map, "providerId"));
                entity.setTitleId(Converters.parseString(map, "titleId"));
                return entity;
            }
        };
    }

    private static String parseString(Map<String, Object> map, String key) {
        return (String)map.get(key);
    }

    private static Boolean parseBoolean(Map<String, Object> map, String key) {
        return (Boolean)map.get(key);
    }

    private static Date parseDate(Map<String, Object> map, String key) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse((String)map.get(key));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    private static Integer parseInteger(Map<String, Object> map, String key) {
        Integer i = (Integer)map.get(key);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private static Collection<String> parseStringArray(Map<String, Object> map, String key) {
        return (Collection)map.get(key);
    }
}

