/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.base.Preconditions;
import com.tandbergtv.workflow.api.Activities;
import com.tandbergtv.workflow.api.Processes;
import com.tandbergtv.workflow.api.ResourceGroups;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.Statistics;
import com.tandbergtv.workflow.api.Tasks;
import com.tandbergtv.workflow.api.Templates;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class API {
    private String baseUrl;
    private static final Logger logger = Logger.getLogger(API.class);

    public API(String baseUrl) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
    }

    public Processes processes() {
        return new Processes(this.baseUrl);
    }

    public Resources resources() {
        return new Resources(this.baseUrl);
    }

    public Templates templates() {
        return new Templates(this.baseUrl);
    }

    public ResourceGroups resourceGroups() {
        return new ResourceGroups(this.baseUrl);
    }

    public Activities activities() {
        return new Activities(this.baseUrl);
    }

    public Tasks tasks() {
        return new Tasks(this.baseUrl);
    }

    public Statistics statistics() {
        return new Statistics(this.baseUrl);
    }

    public static class Builder {
        public static final String DEFAULT_BASE_URL = "http://app:7070/workflow";
        public static final String DEFAULT_PATH = "workflow";
        private static final String CONSUL_AGENT_SERVICES_ENDPOINT = "http://localhost:8500/v1/agent/services";
        private static final int TIMEOUT_VALUE = 10000;
        private static String url;

        public Builder() {
            if (url == null) {
                url = this.getWorkflowUrl();
            }
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder url(String href) {
            url = href;
            return this;
        }

        public API build() {
            return new API(url);
        }

        private HttpURLConnection getConnection(String url, String method) throws IOException {
            URL reqUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)reqUrl.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(method);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            return conn;
        }

        private String read(HttpURLConnection connection) throws IOException {
            String line;
            InputStream ris = null;
            ris = connection.getInputStream();
            StringBuffer sb = new StringBuffer();
            BufferedReader br = new BufferedReader(new InputStreamReader(ris));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            if (sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getWorkflowUrl() {
            String workflowUrl = "";
            HttpURLConnection conn = null;
            try {
                conn = this.getConnection(CONSUL_AGENT_SERVICES_ENDPOINT, "GET");
                conn.connect();
                if (conn.getResponseCode() != 200) {
                    throw new IOException("Response status code from consul is: " + conn.getResponseCode());
                }
                JsonFactory factory = new JsonFactory();
                ObjectMapper mapper = new ObjectMapper(factory);
                TypeReference<Map<String, Object>> ref = new TypeReference<Map<String, Object>>(){};
                Map responseMap = (Map)mapper.readValue(this.read(conn), (TypeReference)ref);
                for (Map.Entry e : responseMap.entrySet()) {
                    if (!((String)e.getKey()).startsWith(DEFAULT_PATH)) continue;
                    Map workflowServiceMap = (Map)e.getValue();
                    String address = (String)workflowServiceMap.get("Address");
                    Integer port = (Integer)workflowServiceMap.get("Port");
                    workflowUrl = "http://" + address + ":" + port.toString() + "/" + DEFAULT_PATH;
                }
            }
            catch (Exception e) {
                logger.info((Object)("Failed to get workflow url from consul: " + e.getMessage() + ", using default."));
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            if (workflowUrl.isEmpty()) {
                workflowUrl = DEFAULT_BASE_URL;
            }
            return workflowUrl;
        }
    }
}

