/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.Converters;
import com.tandbergtv.workflow.api.model.process.Activity;
import com.tandbergtv.workflow.api.model.process.ActivityListResponse;
import com.tandbergtv.workflow.api.model.process.ActivityQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class Activities
extends AbstractClientRequest<ActivityListResponse> {
    private String baseUrl;
    private ActivityQueryBuilder query;

    Activities(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new ActivityQueryBuilder(this.baseUrl);
    }

    public ActivityQueryBuilder query() {
        return this.query;
    }

    @Override
    public ActivityListResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        Integer total = this.getTotal();
        List list = (List)map.get("activity");
        return new ActivityListResponse(this.getItems(list), total);
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }

    private List<Activity> getItems(List<Map<String, Object>> response) {
        return Lists.transform(response, Converters.forActivity());
    }
}

