/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.hibernate;

import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class WorkflowNodeLogHDAO {
    private static final Logger LOGGER = Logger.getLogger(WorkflowNodeLogHDAO.class);
    private Session session;

    public WorkflowNodeLogHDAO(Session session) {
        this.session = session;
    }

    public WorkflowNodeLog findCurrentByTokenAndNode(Token token, Node node) {
        WorkflowNodeLog log = null;
        LOGGER.debug((Object)("Retreiving the current workflow node log for tokenId: " + token.getId() + " nodeId: " + node.getId()));
        try {
            Query nlQuery = this.session.createQuery(this.buildLatestJBPMNodeLogQuery(node, token));
            Object obj = nlQuery.uniqueResult();
            long nodeLogID = obj != null ? (Long)obj : -1L;
            Query wnlQuery = this.session.createQuery(this.buildFindCurrentByTokenAndNodeQuery(node, token, nodeLogID));
            obj = wnlQuery.uniqueResult();
            if (obj != null) {
                log = new WorkflowNodeLog((Long)obj);
            }
            LOGGER.debug((Object)(token + ", log id " + obj));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Could not get the current workflow node log for tokenId: " + token.getId() + " nodeId: " + node.getId()), (Throwable)ex);
        }
        return log;
    }

    private String buildFindCurrentByTokenAndNodeQuery(Node node, Token token, long nodeLogID) {
        String query = "select max(wnl.id) from WorkflowNodeLog wnl where wnl.node.id = " + node.getId() + " and wnl.token.id = " + token.getId() + " and wnl.id > " + nodeLogID;
        return query;
    }

    private String buildLatestJBPMNodeLogQuery(Node node, Token token) {
        String query = "select max(nl.id) from NodeLog nl where nl.node.id = " + node.getId() + " and nl.token.id = " + token.getId();
        return query;
    }
}

