/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.graph.command.FailToken;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class EmailExceptionHandler
implements ActionHandler {
    private static final String BODY = "exception.mail.body";
    private static final String SUBJECT = "exception.mail.subject";
    private String email;
    private String subject;
    private static final String MAIL_SERVICE_KEY = "mail.service.jndi.name";
    private static final String BUNDLE_NAME = EmailExceptionHandler.class.getPackage().getName() + ".mail";
    private static final Logger logger = Logger.getLogger(EmailExceptionHandler.class);
    private static final long serialVersionUID = 211838311322320212L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) throws Exception {
        try {
            if (this.email != null && this.email.length() > 0) {
                Message message = this.createMessage(context);
                Transport.send((Message)message);
                logger.info((Object)(context.getToken() + ", sent email to " + this.email));
            }
        }
        catch (NamingException e) {
            logger.warn((Object)(context.getToken() + ", failed to send email to " + this.email + " - " + e.getMessage()));
        }
        catch (Throwable e) {
            logger.warn((Object)(context.getToken() + ", failed to send email to " + this.email), e);
        }
        finally {
            new FailToken().execute(context);
        }
    }

    protected Message createMessage(ExecutionContext context) throws NamingException, MessagingException {
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        Session session = (Session)new InitialContext().lookup(bundle.getString(MAIL_SERVICE_KEY));
        MimeMessage message = new MimeMessage(session);
        message.setRecipients(MimeMessage.RecipientType.TO, this.getEmailRecipients(context).toArray(new Address[0]));
        message.setSubject(this.getEmailSubject(bundle));
        message.setText(this.getEmailBody(bundle, context));
        return message;
    }

    protected List<Address> getEmailRecipients(ExecutionContext context) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        String[] recipients = this.email.split(",");
        for (int i = 0; i < recipients.length; ++i) {
            Object value;
            String recipient = recipients[i].trim();
            if (recipient.startsWith("$") && (value = context.getVariable(recipient.substring(1))) instanceof String) {
                recipient = (String)value;
            }
            try {
                addresses.add((Address)new InternetAddress(recipient));
                logger.debug((Object)("Sending to " + recipient));
                continue;
            }
            catch (AddressException e) {
                // empty catch block
            }
        }
        return addresses;
    }

    protected String getEmailSubject(ResourceBundle bundle) {
        if (this.subject != null && this.subject.length() > 0) {
            return this.subject;
        }
        return bundle.getString(SUBJECT);
    }

    protected String getEmailBody(ResourceBundle bundle, ExecutionContext context) {
        String name = context.getProcessDefinition().getName();
        long id = context.getProcessInstance().getId();
        String node = context.getNode().getName();
        String pattern = bundle.getString(BODY);
        return MessageFormat.format(pattern, name, id, node);
    }
}

