/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.neptune;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.auth.IUserProvider;
import com.tandbergtv.workflow.auth.User;
import com.tandbergtv.workflow.web.neptune.NeptuneClient;
import com.tandbergtv.workflow.web.neptune.exception.NeptuneException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class NeptuneUserProvider
implements IUserProvider {
    public static final String KEY_ROLE_SETS = "roleSets";
    public static final String KEY_USERS_AND_ROLES = "usersAndRoles";
    private static final Logger logger = Logger.getLogger(NeptuneUserProvider.class);
    private final HttpServletRequest httpRequest;

    public NeptuneUserProvider() {
        this.httpRequest = null;
    }

    public NeptuneUserProvider(HttpServletRequest request) {
        this.httpRequest = request;
    }

    public SortedSet<User> getUsersWithUserTaskPermissions() {
        NeptuneClient<Map> request = this.getNeptuneClient();
        try {
            Map map = request.invoke(Map.class, null);
            List users = (List)map.get(KEY_USERS_AND_ROLES);
            return Sets.newTreeSet((Iterable)Collections2.filter((Collection)Lists.transform((List)users, this.function()), (Predicate)Predicates.notNull()));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get list of users", (Throwable)e);
            throw new NeptuneException("fail to get user list", e);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get list of users", (Throwable)e);
            return Sets.newTreeSet();
        }
    }

    protected NeptuneClient<Map> getNeptuneClient() {
        NeptuneClient<Map> request = this.httpRequest == null ? new NeptuneClient<Map>(NeptuneClient.Route.USER_DETAILS) : new NeptuneClient(this.httpRequest.getUserPrincipal(), NeptuneClient.Route.USER_DETAILS);
        return request;
    }

    private Function<Map<String, Object>, User> function() {
        return new Function<Map<String, Object>, User>(){

            public User apply(Map<String, Object> map) {
                List roleSets = (List)map.get(NeptuneUserProvider.KEY_ROLE_SETS);
                if (!roleSets.contains("UserTasks_PerformTask")) {
                    return null;
                }
                try {
                    User user = new User();
                    user.setUserName(map.get("userName").toString());
                    user.setEmail(map.get("email").toString());
                    return user;
                }
                catch (Exception e) {
                    logger.warn((Object)("invalid user: " + map + ", error: " + e.getLocalizedMessage()));
                    return null;
                }
            }
        };
    }
}

