/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.neptune;

import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.web.neptune.NeptuneClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class NeptuneSettingsProvider
implements ISettingsProvider {
    private static final Logger logger = Logger.getLogger(NeptuneSettingsProvider.class);
    private static final String IGNORE_VALIDATION = "?ignoreValidation=true";
    private static final int RETRIES = 1;
    private static final int RETRY_INTERVAL = 10;
    private int retry = 1;
    private int interval = 10;

    @Override
    public Map<String, String> getProperties(String path) {
        NeptuneClient<Map> request = this.getClient(path);
        int count = 0;
        while (true) {
            try {
                Map map = request.invoke(Map.class, null);
                logger.debug((Object)("Settings for path " + path + " " + map));
                return map;
            }
            catch (Exception e) {
                if (++count <= this.retry && e instanceof IOException) {
                    try {
                        logger.warn((Object)("Failed to get settings for " + path + ", retrying attempt " + count + " out of total " + this.retry), (Throwable)e);
                        Thread.sleep(this.interval * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                return new HashMap<String, String>();
            }
            break;
        }
    }

    @Override
    public String getPropertiesAsJSON(String path) {
        NeptuneClient<Map> request = this.getClient(path);
        int count = 0;
        while (true) {
            try {
                String json = request.getResponseAsString();
                logger.debug((Object)("Settings for path " + path + " " + json));
                return json;
            }
            catch (Exception e) {
                if (++count <= this.retry && e instanceof IOException) {
                    try {
                        logger.warn((Object)("Failed to get settings for " + path + ", retrying attempt " + count + " out of total " + this.retry), (Throwable)e);
                        Thread.sleep(this.interval * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                return "{}";
            }
            break;
        }
    }

    protected NeptuneClient<Map> getClient(String path) {
        return new NeptuneClient<Map>(NeptuneClient.Route.SETTINGS, path);
    }

    @Override
    public void saveSingleSetting(String path, String name, String value) throws Exception {
        NeptuneClient<Void> request = new NeptuneClient<Void>(NeptuneClient.Route.SETTINGS_SAVE, path, IGNORE_VALIDATION);
        try {
            request.invoke(Void.class, "{\"" + name + "\":\"" + value + "\"}");
            logger.debug((Object)("Saved setting " + path + " " + name + ", " + value));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to save settings for " + path), (Throwable)e);
        }
    }

    @Override
    public void saveSettings(String path, Map<String, String> settings) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

