/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.core.queue.AbstractQueue;
import com.tandbergtv.workflow.core.queue.IQueueRemoveStrategy;
import com.tandbergtv.workflow.core.queue.QueueException;
import com.tandbergtv.workflow.core.queue.QueueItem;
import com.tandbergtv.workflow.driver.message.queue.MessageOffloadQueue;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import java.util.Date;
import org.apache.log4j.Logger;

final class RemovalStrategy<T>
implements IQueueRemoveStrategy<WorkflowMessage> {
    private MessageOffloadQueue<WorkflowMessage> queue;
    private ICommandExecutor executor;
    private static final Logger LOGGER = Logger.getLogger(RemovalStrategy.class);

    public RemovalStrategy(MessageOffloadQueue<WorkflowMessage> queue, ICommandExecutor commandExecutor) {
        this.queue = queue;
        this.executor = commandExecutor;
    }

    public AbstractQueue<WorkflowMessage> getQueue() {
        return this.queue;
    }

    public QueueItem<WorkflowMessage> peek() {
        return this.queue.getFirst();
    }

    public QueueItem<WorkflowMessage> remove() {
        return this.remove(this.peek());
    }

    private QueueItem<WorkflowMessage> remove(QueueItem<WorkflowMessage> item) {
        if (item == null) {
            throw new QueueException("Queue is empty");
        }
        LOGGER.debug((Object)"Going to remove item");
        WorkflowMessage message = (WorkflowMessage)item.getItem();
        item.setLeave(new Date());
        this.executor.executeImmediate(message);
        return item;
    }
}

