/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.ericsson.cms.neptune.cluster.config.ConfigBuilder;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cluster.ClusterService;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.ServiceLifecycleListener;
import com.tandbergtv.workflow.core.service.preferences.IUserPreferenceManager;
import com.tandbergtv.workflow.core.service.preferences.UserPreferenceManagerFactory;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.Recorders;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import com.tandbergtv.workflow.monitor.event.EventHandlerRegistry;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.monitor.internal.AlarmNotificationService;
import com.tandbergtv.workflow.userprovider.IUserProviderService;
import com.tandbergtv.workflow.userprovider.UserProviderService;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.management.JMException;
import org.apache.log4j.Logger;

public class Activator {
    private static final int DEFAULT_HAZELCAST_PORT = 5712;
    private static final String SCHEDULER_NAME = "recorder";
    private static final String STATS_DIR = "stats";
    private static final String FS_RECORDER = "fs-recorder";
    private static final String LOG_RECORDER = "log-recorder";
    private static final String CLUSTER_PROPERTIES = "cluster.properties";
    private static final Logger LOGGER = Logger.getLogger(Activator.class);

    public void start() {
        UserPreferenceManagerFactory factory = UserPreferenceManagerFactory.newInstance();
        this.addService((Service)factory.newUserPreferenceManager());
        this.addService(new EventHandlerRegistry());
        ServiceLifecycleListener listener = new ServiceLifecycleListener();
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".dependencies");
        for (String key : Collections.list(bundle.getKeys())) {
            listener.addDependencyFor(key, bundle.getString(key));
        }
        this.addService((Service)listener);
        this.addService((Service)new AlarmNotificationService());
        this.joinCluster();
        this.addService((Service)new DistributedScheduler("timing-monitor", 2));
        this.addService(new UserProviderService());
        this.startRecorder();
        this.addObservers();
    }

    public void stop() {
        this.removeService(FS_RECORDER);
        this.removeService(LOG_RECORDER);
        this.removeService(ServiceLifecycleListener.class);
        this.removeService(IEventHandlerRegistry.class);
        this.removeService("timing-monitor");
        this.leaveCluster();
        this.removeService(IAlarmNotificationService.class);
        this.removeService(IUserPreferenceManager.class);
        this.removeService(IUserProviderService.class);
    }

    private void joinCluster() {
        try {
            Config config = (Config)new ConfigBuilder(Paths.get(ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath"), CLUSTER_PROPERTIES).toString()).defaultPort(5712).build();
            ClusterService clusterService = new ClusterService(config);
            this.addService((Service)clusterService);
            clusterService.getInstance().getCluster().addMembershipListener(new MembershipListener(){

                public void memberRemoved(MembershipEvent e) {
                    LOGGER.warn((Object)e.getMember().getSocketAddress());
                }

                public void memberAdded(MembershipEvent e) {
                    LOGGER.info((Object)e.getMember().getSocketAddress());
                }

                public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
                    LOGGER.info((Object)memberAttributeEvent.getMember().getSocketAddress());
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot join cluster", e);
        }
    }

    private void leaveCluster() {
        IClusterService clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        clusterService.getInstance().getLifecycleService().shutdown();
        Hazelcast.shutdownAll();
        this.removeService(ClusterService.class);
    }

    private void startRecorder() {
        Scheduler pool = new Scheduler(SCHEDULER_NAME, 1, 1);
        String dir = System.getProperty("java.io.tmpdir");
        try {
            dir = ApplicationProperties.getInstance().getProperty("install.dir");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String path = dir + File.separator + STATS_DIR;
        System.setProperty("com.tandbergtv.watchpoint.statsdir", path);
        this.addService((Service)Recorders.toFileSystem((ISchedulerService)pool, (String)FS_RECORDER));
        this.addService((Service)Recorders.toLog((ISchedulerService)pool, (String)LOG_RECORDER, (int)60000));
    }

    private void addObservers() {
        IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup(FS_RECORDER);
        this.addObserver(recorder, "java.lang:type=Threading", "ThreadCount");
        this.addObserver(recorder, "com.tandbergtv.watchpoint:type=Page,*", "EWMA");
    }

    private void addObserver(IRecorder recorder, String name, String attribute) {
        try {
            IObserver observer = Observers.localJMXObserver((String)name, (String)attribute);
            recorder.addObserver(observer);
        }
        catch (JMException e) {
            Logger.getLogger(Activator.class).warn((Object)":(", (Throwable)e);
        }
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

