/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.driver.template.watch.AbstractTemplateReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ProcessArchive;
import org.springframework.util.Assert;

public class PackagedFileReader
extends AbstractTemplateReader
implements ITemplateReader {
    public PackagedFileReader(File file) {
        Assert.notNull((Object)file, (String)"file cannot be null");
        this.file = file;
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.file));
            ProcessArchive par = new ProcessArchive(zipInputStream);
            byte[] bytes = par.getEntry("processdefinition.xml");
            if (bytes == null) {
                throw new JpdlException("No processdefinition.xml inside process archive " + this.file.getAbsolutePath());
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new TemplateReaderException("Failed to read template " + this.file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

