/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.driver.template.ExtendedJpdlXmlReader;
import com.tandbergtv.workflow.exe.resource.ReleaseResource;
import com.tandbergtv.workflow.exe.resource.RequestResource;
import com.tandbergtv.workflow.exe.resource.SetResource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.node.StartState;
import org.jbpm.taskmgmt.def.Task;

public class AbstractWFSJpdlXmlReader
extends ExtendedJpdlXmlReader {
    private static final long serialVersionUID = -6825024606160797395L;
    protected List<ResourceGroup> groups;
    private static final String ACCESS = "read,write,required";
    private static final String PROVIDER_DISPLAY_NAME = "Provider ID";
    private static final String PROVIDER_ID = "providerId";
    private static final String TITLE_ID = "titleId";
    private static Map<String, Class<?>> map = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("resource-release", ReleaseResource.class);
            this.put("resource-request", RequestResource.class);
            this.put("set-resource", SetResource.class);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(AbstractWFSJpdlXmlReader.class);

    public Map<String, String> getPredefinedActions() {
        HashMap<String, String> actions = new HashMap<String, String>();
        for (String key : map.keySet()) {
            actions.put(key, map.get(key).getName());
        }
        return actions;
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        Element child;
        if (node instanceof StartState) {
            Task task = this.processDefinition.getTaskMgmtDefinition().getStartTask();
            if (task != null) {
                this.addProviderIdVariable(task);
            }
        } else if (node instanceof ResourceGroupAware && (child = nodeElement.element("resource-group")) != null) {
            this.readResourceGroup(child, node);
        }
    }

    protected void readResourceGroup(Element element, Node node) {
        String name = element.attributeValue("name");
        boolean found = false;
        for (ResourceGroup group : this.groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            found = true;
            LOGGER.debug((Object)("Found resource group " + group.getId() + " for " + name));
            if (!(node instanceof ResourceGroupAware)) break;
            ((ResourceGroupAware)node).setResourceGroupID(Long.valueOf(group.getId()));
            break;
        }
        if (!found) {
            this.addError("Failed to find resource group " + name + " at node " + node.getName());
        }
    }

    protected void addProviderIdVariable(Task task) {
        List variables = task.getTaskController().getVariableAccesses();
        if (!this.hasTitleIdVariable(variables)) {
            return;
        }
        TaskVariable providerId = this.getProviderIdVariable(variables);
        if (providerId == null) {
            variables.add(this.createProviderIdVariable());
            LOGGER.info((Object)"Added providerId variable");
        } else if (!providerId.isRequired()) {
            this.makeVariableRequired(variables, providerId);
            LOGGER.info((Object)"Variable providerId is required");
        }
    }

    protected boolean hasTitleIdVariable(Collection<TaskVariable> variables) {
        for (TaskVariable variable : variables) {
            if (!TITLE_ID.equals(variable.getVariableName()) || !variable.isRequired()) continue;
            return true;
        }
        return false;
    }

    protected TaskVariable getProviderIdVariable(Collection<TaskVariable> variables) {
        for (TaskVariable variable : variables) {
            if (!PROVIDER_ID.equals(variable.getVariableName())) continue;
            return variable;
        }
        return null;
    }

    protected TaskVariable createProviderIdVariable() {
        return new TaskVariable(PROVIDER_ID, ACCESS, PROVIDER_DISPLAY_NAME, Datatype.STRING);
    }

    protected void makeVariableRequired(Collection<TaskVariable> variables, TaskVariable variable) {
        variables.remove(variable);
        variables.add(new TaskVariable(variable.getVariableName(), ACCESS, variable.getMappedName(), variable.getDatatype()));
    }
}

