/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessageAttachment;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowPayload;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WorkflowMessage
implements Serializable {
    private static final long serialVersionUID = -5033284231280350895L;
    protected IMessageUID uid;
    protected IMessageKey key;
    protected IMessageKey origin;
    protected WorkflowPayload payload;
    protected IMessageAttachment attachment;
    protected ISource source;
    protected IDestination responseDestination;
    protected MessageType type;
    protected WPCLCommand command;

    public WorkflowMessage(IMessageUID uid) {
        this(uid, null, MessageType.control);
    }

    public WorkflowMessage(IMessageUID uid, IMessageKey key) {
        this(uid, key, MessageType.control);
    }

    public WorkflowMessage(IMessageUID uid, MessageType type) {
        this(uid, null, type);
    }

    public WorkflowMessage(IMessageUID uid, IMessageKey key, MessageType type) {
        this.key = key;
        this.uid = uid;
        this.type = type;
        this.payload = new WorkflowPayload();
    }

    public WorkflowMessage(IMessageUID uid, IMessageKey key, IMessageKey origin, MessageType type) {
        this.uid = uid;
        this.key = key;
        this.origin = origin;
        this.type = type;
        this.payload = new WorkflowPayload();
    }

    public IMessageUID getMessageUID() {
        return this.uid;
    }

    public void setMessageUID(IMessageUID uid) {
        this.uid = uid;
    }

    public IMessageKey getKey() {
        return this.key;
    }

    public void setKey(IMessageKey key) {
        this.key = key;
    }

    public IMessageKey getOrigin() {
        return this.origin;
    }

    public WorkflowPayload getPayload() {
        return this.payload;
    }

    public void setPayload(WorkflowPayload payload) {
        if (payload == null) {
            payload = new WorkflowPayload();
        }
        this.payload = payload;
    }

    @Deprecated
    public String getValue(String name) {
        return this.payload.getValue(name);
    }

    public Object getParameterValue(String name) {
        return this.payload.getParameterValue(name);
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String name : this.payload.getParameterNames()) {
            parameters.put(name, this.getParameterValue(name));
        }
        return parameters;
    }

    public void putValue(String name, String value) {
        this.payload.putValue(name, value);
    }

    public void putValue(String name, Object object) {
        this.payload.putValue(name, object);
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public WPCLCommand getCommand() {
        return this.command;
    }

    public void setCommand(WPCLCommand command) {
        this.command = command;
    }

    public IMessageAttachment getAttachment() {
        return this.attachment;
    }

    public void addAttachment(IMessageAttachment attachment) {
        this.attachment = attachment;
    }

    public ISource getSource() {
        return this.source;
    }

    public void setSource(ISource source) {
        this.source = source;
    }

    public IDestination getResponseDestination() {
        return this.responseDestination;
    }

    public void setResponseDestination(IDestination responseDestination) {
        this.responseDestination = responseDestination;
    }

    public boolean match(Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return false;
        }
        for (String name : parameters.keySet()) {
            Object value = parameters.get(name);
            if (value.equals(this.getParameterValue(name))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Message [").append(this.uid).append("], payload=").append(this.payload);
        if (this.attachment != null) {
            buf.append(", attachment=").append(this.attachment);
        }
        return buf.toString();
    }

    public static enum MessageType {
        control,
        ack,
        nack,
        notification,
        error;

    }
}

