/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.registry;

import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.registry.MessageDetail;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class MessageRegistry
implements IMessageRegistry {
    private static final Logger LOGGER = Logger.getLogger(MessageRegistry.class);
    private final Map<String, Set<IMessageUID>> messages;
    private final Map<String, MessageDetail> messagesUIDMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public MessageRegistry() {
        this.messages = new HashMap<String, Set<IMessageUID>>();
        this.messagesUIDMap = new HashMap<String, MessageDetail>();
    }

    @Override
    public void registerMessages(String deviceSystemId, Set<IMessageUID> messageUIDs) {
        this.lock.writeLock().lock();
        try {
            LOGGER.debug((Object)("Adding messages with " + this.messages));
            Set<IMessageUID> oldMessages = this.messages.put(deviceSystemId, messageUIDs);
            if (oldMessages != null) {
                for (IMessageUID oldMessage : oldMessages) {
                    this.messagesUIDMap.remove(oldMessage.getUID());
                }
            }
            if (messageUIDs != null) {
                for (IMessageUID message : messageUIDs) {
                    MessageDetail detail = new MessageDetail(message, deviceSystemId);
                    this.messagesUIDMap.put(message.getUID(), detail);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterMessages(String deviceSystemId) {
        this.lock.writeLock().lock();
        try {
            Set<IMessageUID> oldMessages = this.messages.remove(deviceSystemId);
            if (oldMessages != null) {
                for (IMessageUID uid : oldMessages) {
                    this.messagesUIDMap.remove(uid.getUID());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IMessageUID getMessageUID(String uid) {
        MessageDetail detail = this.getMessageDetail(uid);
        return detail != null ? detail.getMessageUID() : null;
    }

    @Override
    public String getMessageDeviceID(String uid) {
        MessageDetail detail = this.getMessageDetail(uid);
        return detail != null ? detail.getDeviceSystemId() : null;
    }

    private MessageDetail getMessageDetail(String uid) {
        MessageDetail detail = null;
        this.lock.readLock().lock();
        try {
            detail = this.messagesUIDMap.get(uid);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return detail;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.messages.clear();
            this.messagesUIDMap.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

