/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.tandbergtv.workflow.monitor.Metrics;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.JMXObserver;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.management.JMException;
import javax.management.ObjectName;

public class Observers {
    public static IObserver localJMXObserver(String name, String attribute) throws JMException {
        return new JMXObserver(ManagementFactory.getPlatformMBeanServer(), new ObjectName(name), attribute);
    }

    public static IObserver randomObserver() {
        return new IObserver(){
            private final long t = System.currentTimeMillis();

            @Override
            public List<Metric> getMetrics() {
                return Collections.singletonList(Metrics.newMetric("Value", "Random", "random-" + this.t, UUID.randomUUID()));
            }

            @Override
            public Set<Metric> getMetricNames() {
                return Collections.singleton(Metrics.newMetric("Value", "Random", "random-" + this.t, null));
            }
        };
    }
}

