/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.core;

import com.tandbergtv.workflow.monitor.core.ISample;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class MetricSample
implements ISample,
Serializable {
    private static final long serialVersionUID = 7398958484158815686L;
    private String name;
    private AtomicLong total;
    private AtomicLong count;
    private double ewma;
    private double alpha = 0.3;

    public MetricSample(String name) {
        this.name = name;
        this.count = new AtomicLong(0L);
        this.total = new AtomicLong(0L);
    }

    public static MetricSample fromMetricSample(ISample other) {
        MetricSample sample = new MetricSample(other.getName());
        sample.ewma = other.getEWMA();
        sample.count = new AtomicLong(other.getCount());
        sample.total = new AtomicLong(other.getTotal());
        return sample;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void add(long delta) {
        this.count.incrementAndGet();
        this.total.getAndAdd(delta);
        double ma = this.count.get() == 1L ? (double)delta : this.ewma * (1.0 - this.alpha) + this.alpha * (double)delta;
        this.ewma = ma > 1.0E-4 ? ma : 0.0;
    }

    @Override
    public long getTotal() {
        return this.total.longValue();
    }

    @Override
    public long getCount() {
        return this.count.longValue();
    }

    @Override
    public double getAverage() {
        if (this.count.get() == 0L) {
            return 0.0;
        }
        return this.total.doubleValue() / (double)this.count.intValue();
    }

    @Override
    public double getEWMA() {
        return this.ewma;
    }

    @Override
    public double get95thPercentile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double get99thPercentile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMinimum() {
        return Long.MIN_VALUE;
    }

    @Override
    public long getMaximum() {
        return Long.MAX_VALUE;
    }
}

