/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class Configuration {
    private boolean ignoreEmptyValue = true;
    private IConfigurationResource resource;

    protected Configuration(IConfigurationResource resource) {
        this.resource = resource;
    }

    public Configuration ignoreEmptyValue(boolean ignoreEmptyValue) {
        this.ignoreEmptyValue = ignoreEmptyValue;
        return this;
    }

    public static Configuration build(final ResourceBundle bundle) {
        Assert.notNull((Object)bundle);
        return new Configuration(new IConfigurationResource(){

            @Override
            public String getString(String key) {
                return bundle.getString(key);
            }
        });
    }

    public static Configuration build(final Properties properties) {
        Assert.notNull((Object)properties);
        return new Configuration(new IConfigurationResource(){

            @Override
            public String getString(String key) {
                return properties.getProperty(key);
            }
        });
    }

    public static int toInteger(String value, int defaultValue) {
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(StringUtils.trimToEmpty((String)value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long toLong(String value, long defaultValue) {
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(StringUtils.trimToEmpty((String)value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static List<String> toStringList(String value) {
        if (StringUtils.isBlank((String)value)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        String valueString = Configuration.extractValue(value);
        if (valueString.length() > 0) {
            Object[] mapValueArray = valueString.split(",");
            result.addAll(Lists.newArrayList((Object[])mapValueArray));
        }
        return result;
    }

    public static List<Long> toLongList(String value) {
        if (StringUtils.isBlank((String)value)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        String valueString = Configuration.extractValue(value);
        if (valueString.length() > 0) {
            String[] valueArray;
            for (String v : valueArray = valueString.split(",")) {
                result.add(Configuration.toLong(v, 0L));
            }
        }
        return result;
    }

    public static List<Integer> toIntegerList(String value) {
        if (StringUtils.isBlank((String)value)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        String valueString = Configuration.extractValue(value);
        if (valueString.length() > 0) {
            String[] valueArray;
            for (String v : valueArray = valueString.split(",")) {
                result.add(Configuration.toInteger(v, 0));
            }
        }
        return result;
    }

    private static String extractValue(String value) {
        String[] leftBrackets = new String[]{"[", "{", "("};
        String[] rightBrackets = new String[]{"]", "}", ")"};
        String cleanValue = value;
        for (String leftBracket : leftBrackets) {
            if (!cleanValue.startsWith(leftBracket)) continue;
            cleanValue = StringUtils.removeStart((String)cleanValue, (String)leftBracket);
            break;
        }
        for (String rightBracket : rightBrackets) {
            if (!cleanValue.endsWith(rightBracket)) continue;
            cleanValue = StringUtils.removeEnd((String)cleanValue, (String)rightBracket);
            break;
        }
        return cleanValue.trim();
    }

    public static long toLong(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        long newValue = defaultValue;
        if (value instanceof String) {
            newValue = Configuration.toLong("" + value, defaultValue);
        }
        if (value instanceof Number) {
            newValue = ((Number)value).longValue();
        }
        return newValue;
    }

    public int getInteger(String key, int defaultValue) {
        return Configuration.toInteger(this.getValue(key), defaultValue);
    }

    public int getInteger(String key) {
        String value = this.getValue(key);
        try {
            return Integer.parseInt(StringUtils.trimToEmpty((String)value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.invalidDateFormatMessage(key, value));
        }
    }

    private String invalidDateFormatMessage(String key, String value) {
        return "The value of the key [" + key + "] is invalid : " + value;
    }

    public long getLong(String key) {
        String value = this.getValue(key);
        try {
            return Long.parseLong(StringUtils.trimToEmpty((String)value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.invalidDateFormatMessage(key, value));
        }
    }

    public boolean getBoolean(String key) {
        String value = this.getValue(key);
        try {
            return Boolean.parseBoolean(StringUtils.trimToEmpty((String)value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.invalidDateFormatMessage(key, value));
        }
    }

    public List<String> getStringList(String key) {
        return Configuration.toStringList(this.resource.getString(key));
    }

    public long getLong(String key, long defaultValue) {
        return Configuration.toLong(this.getValue(key), defaultValue);
    }

    public String getString(String key) {
        return this.getValue(key);
    }

    private String getValue(String key) {
        String value = this.resource.getString(key);
        if (!this.ignoreEmptyValue) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((String)value), (String)("The value of the key [" + key + "] cannot be null or empty"));
        }
        return value;
    }

    public static boolean toBoolean(String value, boolean defaultValue) {
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(StringUtils.trimToEmpty((String)value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static List<Integer> toIntList(String value, List<Integer> defaultValue) {
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        ArrayList intSet = Lists.newArrayList();
        Iterable results = Splitter.onPattern((String)"[,;]").trimResults().omitEmptyStrings().split((CharSequence)value);
        for (String slice : results) {
            try {
                String cleanValue = StringUtils.remove((String)slice, (String)"[");
                cleanValue = StringUtils.remove((String)cleanValue, (String)"]");
                int intValue = Integer.parseInt(StringUtils.trimToEmpty((String)cleanValue));
                intSet.add(intValue);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return intSet;
    }

    public int getBoolean(String key, int defaultValue) {
        return Configuration.toInteger(this.getValue(key), defaultValue);
    }

    static interface IConfigurationResource {
        public String getString(String var1);
    }
}

