/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.IExtendedSubProcessResolver;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.graph.exe.Transitions;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.logging.log.ProcessLog;

public class Exec
extends ProcessState {
    private static final long serialVersionUID = -5608286665493465148L;
    private static final Logger LOGGER = Logger.getLogger(Exec.class);

    public Set<?> getVariableAccesses() {
        return this.variableAccesses;
    }

    public Transition getDefaultLeavingTransition() {
        Transition leaving = Transitions.createDefaultLeavingTransition((Node)this);
        if (leaving != null) {
            return leaving;
        }
        return super.getDefaultLeavingTransition();
    }

    public void read(Element element, JpdlXmlReader reader) {
        Element e = element.element("sub-process");
        SubProcessResolver subProcessResolver = (SubProcessResolver)JbpmConfiguration.Configs.getObject((String)"jbpm.sub.process.resolver");
        this.subProcessDefinition = subProcessResolver.findSubProcess(e);
        if (this.subProcessDefinition == null) {
            String name = e.attributeValue("name");
            Problem problem = new Problem(2, "Template " + name + " not found");
            problem.setResource(name);
            reader.addProblem(problem);
            return;
        }
        this.variableAccesses = new HashSet(reader.readVariableAccesses(element));
    }

    public void enter(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        token.acquire();
        if (token.getSubProcessInstance() != null) {
            return;
        }
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        super.enter(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        token.getProcessInstance().lock();
        try {
            for (VariableAccess variable : this.variableAccesses) {
                if (!variable.isReadable()) continue;
                Object value = context.getVariable(variable.getVariableName());
                LOGGER.debug((Object)(token + ", copying " + variable.getVariableName() + ", " + value + " to child"));
                parameters.put(variable.getMappedName(), value);
            }
            this.addMissingVariables(context, parameters);
        }
        finally {
            token.getProcessInstance().unlock();
        }
        IExtendedSubProcessResolver extendedSubProcessResolver = (IExtendedSubProcessResolver)JbpmConfiguration.Configs.getObject((String)"jbpm.sub.process.resolver");
        this.subProcessDefinition = extendedSubProcessResolver.findSubProcess(this.subProcessDefinition.getName());
        try {
            IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
            factory.start(token, this.subProcessDefinition, parameters);
            this.fireEvent("subprocess-created", context);
        }
        catch (Throwable t) {
            try {
                this.raiseException(t, context);
            }
            catch (DelegationException e) {
                LOGGER.warn((Object)(token + ", no exception handler defined for template - " + this.getProcessDefinition().getName()));
                token.fail(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(ExecutionContext context, Transition transition) {
        CustomToken token = (CustomToken)context.getToken();
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        token.release();
        context.setSubProcessInstance((ProcessInstance)this.replaceSubProcessWithLatest(token));
        WorkflowProcess subProcessInstance = (WorkflowProcess)context.getSubProcessInstance();
        CustomToken superProcessToken = subProcessInstance.getSuperProcessToken();
        WorkflowProcess superProcessInstance = superProcessToken.getProcessInstance();
        superProcessInstance.lock();
        subProcessInstance.lock();
        try {
            if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
                ContextInstance superContextInstance = context.getContextInstance();
                ContextInstance subContextInstance = subProcessInstance.getContextInstance();
                for (VariableAccess variableAccess : this.variableAccesses) {
                    if (!variableAccess.isWritable()) continue;
                    String mappedName = variableAccess.getMappedName();
                    Object value = subContextInstance.getVariable(mappedName);
                    String variableName = variableAccess.getVariableName();
                    LOGGER.debug((Object)("copying sub process var '" + mappedName + "' to super process var '" + variableName + "': " + value));
                    if (value == null) continue;
                    superContextInstance.setVariable(variableName, value, (Token)superProcessToken);
                }
            }
        }
        finally {
            subProcessInstance.unlock();
            superProcessInstance.unlock();
        }
        this.fireEvent("subprocess-end", context);
        superProcessToken.setSubProcessInstance(null);
        token.setNode((Node)this);
        context.setTransition(transition);
        this.fireEvent("node-leave", context);
        if (token.getNodeEnter() != null) {
            token.addLog((ProcessLog)new NodeLog((Node)this, token.getNodeEnter(), new Date()));
        }
        context.setTransitionSource((Node)this);
        transition.take(context);
    }

    private WorkflowProcess replaceSubProcessWithLatest(CustomToken token) {
        long subProcessId = token.getSubProcessInstance().getId();
        WorkflowProcess subProcess = Exec.findPersistenceService().get(Long.valueOf(subProcessId));
        if (subProcess == null) {
            LOGGER.error((Object)("Failed to retrieve subprocess by id: " + subProcessId));
        }
        return subProcess;
    }

    public static IPersistenceService findPersistenceService() {
        return (IPersistenceService)ServiceRegistry.getDefault().lookup("Process Persistence Service");
    }

    protected void addMissingVariables(ExecutionContext context, Map<String, Object> parameters) {
        WorkflowTemplate template = (WorkflowTemplate)this.subProcessDefinition;
        for (TaskVariable variable : template.getStartTaskVariables()) {
            Object value;
            String name = variable.getVariableName();
            if (!variable.isRequired() || parameters.get(name) != null || (value = context.getVariable(name)) == null) continue;
            LOGGER.debug((Object)(context.getToken() + ", copying " + name + ", " + value + " to child"));
            parameters.put(name, value);
        }
    }
}

