/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;

public class ExtendedTransition
extends Transition {
    private static final long serialVersionUID = 1256972723858185546L;
    private String fromNodeName;
    private String toNodeName;

    public ExtendedTransition() {
    }

    public ExtendedTransition(String name) {
        super(name);
    }

    public String getFromNodeName() {
        return this.fromNodeName;
    }

    public void setFromNodeName(String fromNodeName) {
        this.fromNodeName = fromNodeName;
    }

    public void setFrom(Node from) {
        this.from = from;
        if (from != null) {
            this.setFromNodeName(from.getName());
        }
    }

    public void setTo(Node to) {
        this.to = to;
        if (to != null) {
            this.setToNodeName(to.getName());
        }
    }

    public String getToNodeName() {
        return this.toNodeName;
    }

    public void setToNodeName(String toNodeName) {
        this.toNodeName = toNodeName;
    }

    public void take(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        if (token.hasParent() && token.getParent().getRequestedStatus() != ProcessStatus.BRANCHED) {
            return;
        }
        token.setNode(this.to);
        this.to.setProcessDefinition((ProcessDefinition)token.getProcessInstance().getProcessDefinition());
        if (!token.isResuming()) {
            SuperState parent = context.getTransitionSource().getSuperState();
            if (parent instanceof NodeGroup && !parent.containsNode(this.to)) {
                parent.leave(context);
            }
        } else {
            token.setResuming(false);
        }
        this.fireEvent("transition", context);
        if (token.getStatus() == ProcessStatus.RUNNING) {
            this.to.enter(context);
        }
    }
}

