/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.tandbergtv.workflow.driver.ILogWriter;
import com.tandbergtv.workflow.driver.internal.TransportClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequestBuilder;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.unit.TimeValue;

public class LogElasticsearchWriterService
implements ILogWriter {
    private static final Logger LOGGER = Logger.getLogger(LogElasticsearchWriterService.class);
    private static final String INDEX_PREFIX = "history_logs_";
    private static final String INDEX_ENTRY_TYPE_NAME = "log";
    private static final String TEMPLATE_NAME = "history_logs_template";
    private static final TimeValue TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final int NUMBER_OF_CACHED_REQUESTS = 5000;
    private static final int FLUSH_INTERVAL_IN_SECONDS = 5;
    private TransportClient client;
    private Properties clusterProperties;
    private BulkProcessor bulkCache;

    public LogElasticsearchWriterService(Properties clusterProperties) {
        this.clusterProperties = clusterProperties;
    }

    public void start() {
        try {
            this.client = TransportClientFactory.createTransportClient(this.clusterProperties);
        }
        catch (UnknownHostException uhe) {
            LOGGER.fatal((Object)"Failed to initialize", (Throwable)uhe);
            return;
        }
        this.ensureIndexTemplateExists();
        this.bulkCache = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)this.createBulkListener()).setBulkActions(5000).setFlushInterval(TimeValue.timeValueSeconds((long)5L)).build();
    }

    public void stop() {
        this.client.close();
    }

    public String getServiceName() {
        return "LogElasticsearchWriterService";
    }

    @Override
    public void save(Map<String, Object> logMap) {
        try {
            String indexSuffix = this.getIndexDate(logMap);
            IndexRequestBuilder addLogRequestBuilder = this.client.prepareIndex(INDEX_PREFIX + indexSuffix, INDEX_ENTRY_TYPE_NAME);
            addLogRequestBuilder.setSource(logMap);
            this.bulkCache.add((IndexRequest)addLogRequestBuilder.request());
        }
        catch (Throwable t) {
            LOGGER.warn((Object)"There was a problem while saving to elasticsearch", t);
        }
    }

    private BulkProcessor.Listener createBulkListener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long id, BulkRequest request) {
                LOGGER.debug((Object)"Sending Bulk Request...");
            }

            public void afterBulk(long id, BulkRequest request, Throwable t) {
                LOGGER.warn((Object)"Bulk request failed with a throwable", t);
            }

            public void afterBulk(long id, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    LOGGER.warn((Object)("Bulk request failed: " + response.buildFailureMessage()));
                } else {
                    LOGGER.debug((Object)"Bulk request succeeded");
                }
            }
        };
    }

    private void ensureIndexTemplateExists() {
        IndicesAdminClient adminClient = this.client.admin().indices();
        GetIndexTemplatesRequestBuilder getBuilder = adminClient.prepareGetTemplates(new String[]{TEMPLATE_NAME});
        List templates = ((GetIndexTemplatesResponse)getBuilder.get(TIMEOUT)).getIndexTemplates();
        if (!templates.isEmpty()) {
            return;
        }
        try {
            String filePath = this.getClass().getPackage().getName().replace('.', '/') + "/indexTemplateMapping.json";
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(filePath);
            String mapping = CharStreams.toString((Readable)new InputStreamReader(stream, Charsets.UTF_8));
            PutIndexTemplateRequestBuilder putBuilder = adminClient.preparePutTemplate(TEMPLATE_NAME);
            putBuilder = putBuilder.setSource(mapping);
            adminClient.putTemplate((PutIndexTemplateRequest)putBuilder.request()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn((Object)"Exception was thrown while trying to create Index Template", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Exception was thrown while trying to read template mapping", (Throwable)e);
        }
        LOGGER.info((Object)"Template created: history_logs_template");
    }

    private String getIndexDate(Map<String, Object> logMap) {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date((Long)logMap.get("eventTimestamp")));
    }
}

