/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateDTO;
import com.tandbergtv.workflow.core.util.HibernateTemplate;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessStatusStatistics;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.search.ISearchHelper;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.TemplateParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class WorkflowProcessSearchHelper
implements ISearchHelper {
    private SessionFactory factory;
    private static final Logger LOGGER = Logger.getLogger(WorkflowProcessSearchHelper.class);
    private static final String PROCESS_ALIAS = "process";
    private static final String TOKEN_ALIAS = "token";
    private static final String WORKFLOW_TEMPLATE_ALIAS = "template";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String NON_ARCHIVED_WHERE_CLAUSE = " AND process.isActive = true";
    private static final String WORKORDER_TEMPLATE_WHERE_CLAUSE = "process.templateId = template.id AND process.id= token.processId AND token.parentTokenId = 0 ";
    private static final String STATISTICS_GROUP_CLAUSE = " GROUP BY token.operationalStatus";

    public WorkflowProcessSearchHelper(SessionFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(SearchCriteria searchCriteria) {
        int count = 0;
        try (Session session = this.factory.openSession();){
            String queryString = this.buildQuery(searchCriteria, QueryType.COUNT);
            if (queryString != null) {
                LOGGER.debug((Object)("Executing count query:" + queryString));
                List queryResult = session.createQuery(queryString).list();
                count = HibernateTemplate.toInteger((List)queryResult);
                LOGGER.debug((Object)("Received count:" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessMonitor statistics(SearchCriteria searchCriteria) {
        ProcessStatusStatistics statistics = null;
        try (Session session = this.factory.openSession();){
            String queryString = this.buildQuery(searchCriteria, QueryType.STATISTICS);
            if (queryString != null) {
                LOGGER.debug((Object)("Executing statistics query:" + queryString));
                List queryResult = session.createQuery(queryString).list();
                HashMap<ProcessStatus, Integer> data = new HashMap<ProcessStatus, Integer>();
                for (Object row : queryResult) {
                    Object[] rowValues = (Object[])row;
                    ProcessStatus status = (ProcessStatus)rowValues[0];
                    int count = ((Number)rowValues[1]).intValue();
                    data.put(status, count);
                }
                statistics = new ProcessStatusStatistics(data);
            }
        }
        return statistics;
    }

    private String buildQuery(SearchCriteria searchCriteria, QueryType queryType) {
        StringBuilder query = new StringBuilder(256);
        this.buildFromClause(searchCriteria, queryType, query);
        String fromClause = query.toString();
        query.setLength(0);
        this.buildSelectClause(searchCriteria, queryType, query);
        query.append(fromClause);
        this.buildWhereClause(searchCriteria, query);
        this.buildOrderClause(searchCriteria, queryType, query);
        return query.toString();
    }

    private void buildSelectClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        queryBuffer.append("SELECT ");
        if (QueryType.STATISTICS.equals((Object)queryType)) {
            queryBuffer.append(TOKEN_ALIAS);
            queryBuffer.append(".operationalStatus, ");
        }
        if (!QueryType.DEFAULT.equals((Object)queryType)) {
            queryBuffer.append("COUNT(");
        }
        if (searchCriteria.isSearchDistinct()) {
            queryBuffer.append("DISTINCT ");
        }
        queryBuffer.append(TOKEN_ALIAS);
        if (QueryType.DEFAULT.equals((Object)queryType)) {
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                if (param.isVarInstance()) {
                    queryBuffer.append(", ").append(param.getAlias());
                    continue;
                }
                if (param.getFieldName().indexOf(".") == -1) continue;
                queryBuffer.append(", ").append(param.getAlias());
                queryBuffer.append(".").append(param.getFieldName());
            }
        } else {
            queryBuffer.append(")");
        }
    }

    private void buildFromClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        queryBuffer.append(" FROM CustomTokenDTO ").append(TOKEN_ALIAS);
        queryBuffer.append(" , WorkflowProcessDTO ").append(PROCESS_ALIAS);
        int objectCount = 1;
        if (queryType.equals((Object)QueryType.DEFAULT)) {
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (!param.isVarInstance() || !(param instanceof SortParameter)) continue;
                queryBuffer.append(param.getPartialFromClause(objectCount++));
            }
        }
        String templateClassName = null;
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            String fromPart;
            if (param.isVarInstance() && param instanceof SortParameter) continue;
            if (param instanceof TemplateParameter) {
                templateClassName = ((TemplateParameter)param).getClassName();
                continue;
            }
            if ((fromPart = param.getPartialFromClause(objectCount++)).length() > 0) {
                queryBuffer.append(", ");
            }
            queryBuffer.append(fromPart);
        }
        if (templateClassName == null) {
            templateClassName = this.getDefaultTemplateClass().getName();
        }
        queryBuffer.append(", ");
        queryBuffer.append(templateClassName).append(" ").append(WORKFLOW_TEMPLATE_ALIAS);
    }

    private Class<?> getDefaultTemplateClass() {
        return WorkflowTemplateDTO.class;
    }

    private void buildWhereClause(SearchCriteria searchCriteria, StringBuilder queryBuffer) {
        boolean firstCondition = true;
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param instanceof TemplateParameter || StringUtils.isBlank((String)param.getPartialWhereClause())) continue;
            queryBuffer.append(firstCondition ? " WHERE " : " AND ");
            queryBuffer.append(param.getPartialWhereClause());
            firstCondition = false;
        }
        queryBuffer.append(firstCondition ? " WHERE " : " AND ");
        queryBuffer.append(WORKORDER_TEMPLATE_WHERE_CLAUSE);
        queryBuffer.append(NON_ARCHIVED_WHERE_CLAUSE);
    }

    private void buildOrderClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        if (QueryType.DEFAULT.equals((Object)queryType)) {
            boolean firstParameter = true;
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                queryBuffer.append(firstParameter ? ORDER_BY : ", ");
                queryBuffer.append(param.getAlias()).append(".").append(param.getSortingColumn());
                String order = param.getSortingOrder() == SortingOrder.ASCENDING ? " ASC" : " DESC";
                queryBuffer.append(order);
                firstParameter = false;
            }
        } else if (QueryType.STATISTICS.equals((Object)queryType)) {
            queryBuffer.append(STATISTICS_GROUP_CLAUSE);
        }
    }

    private static enum QueryType {
        DEFAULT,
        COUNT,
        STATISTICS;

    }
}

