/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.entity.WorkflowProcessDTO;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.CustomTokenConvertor;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.TemplateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WorkflowProcessConvertor {
    private static final Logger logger = Logger.getLogger(WorkflowProcessConvertor.class);
    private ISequenceIdGenerator idGenerator;
    private CustomTokenConvertor customTokenConvertor;
    private ITemplateService templateService;

    public WorkflowProcessConvertor(CustomTokenConvertor customTokenConvertor, ISequenceIdGenerator idGenerator) {
        this.customTokenConvertor = customTokenConvertor;
        this.idGenerator = idGenerator;
    }

    public WorkflowProcessDTO toProcessDTO(WorkflowProcess process) {
        Collection childTokens;
        if (process == null) {
            return null;
        }
        WorkflowProcessDTO processDto = this.toLightProcessDTO(process);
        Collection subProcesses = process.getSubProcessInstances();
        if (!CollectionUtils.isEmpty((Collection)subProcesses)) {
            ArrayList<WorkflowProcessDTO> subProcessDTOs = new ArrayList<WorkflowProcessDTO>();
            for (WorkflowProcess workflowProcess : subProcesses) {
                subProcessDTOs.add(this.toLightProcessDTO(workflowProcess));
            }
            processDto.setSubProcesses(subProcessDTOs);
        }
        if (!CollectionUtils.isEmpty((Collection)(childTokens = process.getRootToken().getChildTokens()))) {
            for (CustomToken child : childTokens) {
                processDto.addChildrenToken(this.customTokenConvertor.toChildCustomTokenDTO(child));
            }
        }
        return processDto;
    }

    public WorkflowProcessDTO toLightProcessDTO(WorkflowProcess process) {
        WorkflowProcessDTO processDto = new WorkflowProcessDTO();
        long processId = process.getId();
        if (process.isNew()) {
            processId = this.idGenerator.queryId();
            process.setId(processId);
            logger.debug((Object)("Workflow Process ID generated: " + processId));
        }
        processDto.setId(processId);
        CustomTokenDTO rootToken = this.customTokenConvertor.toCustomTokenDTO(process.getRootToken());
        processDto.setRootToken(rootToken);
        processDto.setRootTokenId(rootToken.getTokenId());
        CustomToken superProcessToken = process.getSuperProcessToken();
        if (superProcessToken != null) {
            WorkflowProcess parent = superProcessToken.getProcessInstance();
            processDto.setParentId(parent.getId());
        }
        processDto.setTemplateId(process.getTemplateId());
        processDto.setPriority(process.getPriority());
        processDto.setActive(process.isActive());
        processDto.setProcessNotes(process.getNote());
        processDto.setCreateId(process.getCreateId());
        return processDto;
    }

    public WorkflowProcess toProcessObject(WorkflowProcessDTO processDto) {
        if (processDto == null) {
            return null;
        }
        WorkflowProcess process = this.toLightProcess(processDto);
        CustomToken rootToken = process.getRootToken();
        Collection<CustomToken> childTokens = this.buildChildTokens(processDto, rootToken);
        List subProcessDtos = processDto.getSubProcesses();
        if (!CollectionUtils.isEmpty((Collection)processDto.getSubProcesses())) {
            this.buildSubProcesses(rootToken, childTokens, subProcessDtos);
        }
        return process;
    }

    private void buildSubProcesses(CustomToken rootToken, Collection<CustomToken> childTokens, Collection<WorkflowProcessDTO> subProcessDtos) {
        for (WorkflowProcessDTO subProcessDto : subProcessDtos) {
            WorkflowProcess subProcess = this.toLightProcess(subProcessDto);
            this.customTokenConvertor.convertChildTokens(subProcessDto.getChildrenTokens(), subProcess.getRootToken());
            boolean isSubProcessToken = true;
            CustomTokenDTO subTokenDto = subProcessDto.getRootToken();
            for (CustomToken childToken : childTokens) {
                if (subTokenDto.getParentTokenId() != childToken.getId()) continue;
                childToken.setSubProcessInstance((ProcessInstance)subProcess);
                subProcess.setSuperProcessToken((Token)childToken);
                isSubProcessToken = false;
                break;
            }
            if (!isSubProcessToken) continue;
            subProcess.setSuperProcessToken((Token)rootToken);
            rootToken.setSubProcessInstance((ProcessInstance)subProcess);
        }
    }

    private Collection<CustomToken> buildChildTokens(WorkflowProcessDTO processDto, CustomToken rootToken) {
        List childrenTokenDtos = processDto.getChildrenTokens();
        List<CustomToken> childTokens = this.customTokenConvertor.convertChildTokens(childrenTokenDtos, rootToken);
        return childTokens;
    }

    private WorkflowProcess toLightProcess(WorkflowProcessDTO processDto) {
        if (processDto == null) {
            return null;
        }
        WorkflowTemplate template = this.getTemplateById(processDto.getTemplateId());
        WorkflowProcess process = new WorkflowProcess(processDto.getCreateId(), template.getProcessDefinition(), processDto.getPriority());
        process.setId(processDto.getId());
        if (!StringUtils.isEmpty((Object)processDto.getProcessNotes())) {
            WorkflowProcessNote processNote = new WorkflowProcessNote();
            processNote.setNotes(processDto.getProcessNotes());
            process.setNote(processNote);
        }
        process.setActive(processDto.isActive());
        process.setUpdateDate(processDto.getUpdateDate());
        CustomToken customToken = process.getRootToken();
        CustomTokenDTO customTokenDTO = processDto.getRootToken();
        this.customTokenConvertor.refillProcess(customTokenDTO, process);
        this.customTokenConvertor.refillCustomToken(customTokenDTO, customToken);
        return process;
    }

    private WorkflowTemplate getTemplateById(long templateId) {
        return this.getTemplateService().getTemplateById(templateId);
    }

    private ITemplateService getTemplateService() {
        if (this.templateService == null) {
            this.templateService = (TemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
        }
        return this.templateService;
    }

    public void setIdGenerator(ISequenceIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }
}

