/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jbpm.JbpmException;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.util.IoUtil;

public class ExtendedFileDefinition
extends FileDefinition {
    private static final long serialVersionUID = 2787698150122265458L;
    private String dir;
    private static String importedTemplateDir = null;
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";
    private static final String IMPORTED_FOLDER_NAME = "imported";

    private String getImportedTemplateDir() {
        if (importedTemplateDir == null) {
            String dir = System.getProperty(PRODUCT_DIR);
            String workflowroot = String.valueOf(dir) + File.separator + WORKFLOW_FOLDER_NAME;
            importedTemplateDir = String.valueOf(workflowroot) + File.separator + IMPORTED_FOLDER_NAME;
        }
        return importedTemplateDir;
    }

    public void addFile(String name, InputStream is) {
        try {
            if (this.isStoredOnFileSystem()) {
                String fileName = this.getFilePath(name);
                FileOutputStream fos = new FileOutputStream(fileName);
                IoUtil.transfer((InputStream)is, (OutputStream)fos);
                fos.close();
            }
        }
        catch (Exception e) {
            throw new JbpmException("File '" + name + "' could not be stored on filesystem", (Throwable)e);
        }
    }

    public byte[] getBytes(String name) {
        byte[] bytes = null;
        try {
            if (this.isStoredOnFileSystem()) {
                bytes = this.getBytesFromFileSystem(name);
            }
        }
        catch (Exception e) {
            throw new JbpmException("Couldn't read file '" + name + "'", (Throwable)e);
        }
        return bytes;
    }

    private byte[] getBytesFromFileSystem(String name) throws IOException {
        byte[] bytes = null;
        try (InputStream in = null;){
            in = new FileInputStream(this.getFilePath(name));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IoUtil.transfer((InputStream)in, (OutputStream)out);
            bytes = out.toByteArray();
        }
        return bytes;
    }

    private boolean isStoredOnFileSystem() {
        String tempRootDir = this.getImportedTemplateDir();
        boolean isStoredOnFileSystem = true;
        if (this.dir == null) {
            WorkflowTemplate template = (WorkflowTemplate)super.getProcessDefinition();
            this.dir = template.getFullName();
            new File(String.valueOf(tempRootDir) + File.separator + this.dir).mkdirs();
        }
        return isStoredOnFileSystem;
    }

    private String getFilePath(String name) {
        String filePath = String.valueOf(this.getImportedTemplateDir()) + "/" + this.dir + "/" + name;
        new File(filePath).getParentFile().mkdirs();
        return filePath;
    }
}

