/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AbstractHeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MessageSendingHBS
extends AbstractHeartBeatStrategy {
    private static final Logger LOGGER = Logger.getLogger(MessageSendingHBS.class);
    public static final String MESSAGE_UID_KEY = "_messageUID";
    public static final String PAYLOAD_PROPERTIES_KEY = "_payloadProperties";
    public static final String ERROR_MESSAGE_KEY = "_errorMessageProperty";
    public static final String HEARTBEAT_FAILURE_THRESHOLD = "_failureThreshold";

    @Override
    protected Runnable getHeartBeatCommand() {
        return new MessageSendCommand();
    }

    protected WorkflowMessage constructHeartBeatMessage() {
        String messageUID = this.getConfiguration().get(MESSAGE_UID_KEY);
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)messageUID);
        this.constructMessagePayload(message);
        return message;
    }

    protected void constructMessagePayload(WorkflowMessage message) {
        if (message == null) {
            return;
        }
        String payloadProperties = this.getConfiguration().get(PAYLOAD_PROPERTIES_KEY);
        WorkflowPayload payload = message.getPayload();
        if (payloadProperties != null) {
            String[] properties;
            for (String property : properties = payloadProperties.split(",")) {
                if ((property = property.trim()).length() <= 0) continue;
                String value = this.getConfiguration().get(property);
                payload.putValue(property, value);
            }
        }
    }

    protected String getErrorMessageKey() {
        String key = null;
        key = this.getConfiguration().get(ERROR_MESSAGE_KEY);
        return key;
    }

    protected String getErrorMessageInResponse(WorkflowMessage response) {
        String message = "";
        String key = this.getErrorMessageKey();
        if (key == null) {
            return message;
        }
        if (response != null && response.getPayload() != null) {
            WorkflowPayload payload = response.getPayload();
            message = payload.getValue(key);
        }
        return message;
    }

    protected boolean isHeartBeatSuccess(WorkflowMessage response) {
        return response != null && WorkflowMessage.MessageType.ack.equals((Object)response.getType());
    }

    protected int getHeartBeatFailureThreshold() {
        int threshold = 1;
        String value = this.getConfiguration().get(HEARTBEAT_FAILURE_THRESHOLD);
        try {
            if (value != null && (threshold = Integer.parseInt(value)) < 1) {
                threshold = 1;
            }
        }
        catch (NumberFormatException nfe) {
            threshold = 1;
        }
        return threshold;
    }

    class MessageSendCommand
    implements Runnable {
        private int consecutiveHeartBeatFailure = 0;

        MessageSendCommand() {
        }

        @Override
        public void run() {
            Resource hbResource = MessageSendingHBS.this.getResource();
            ResourceType resourceType = hbResource.getResourceType();
            String connectionType = resourceType.getHeartbeatConnectionType().getDisplayName();
            String connectionString = hbResource.getHeartbeatConnectionString();
            IDestination destination = (IDestination)DeviceTypeUtil.createDevice(connectionType, connectionString);
            ArrayList<IDestination> targetDestinations = new ArrayList<IDestination>();
            targetDestinations.add(destination);
            String name = "Resource[id=" + hbResource.getId() + "]: " + hbResource.getName();
            try {
                ResourceHeartBeatEvent event;
                WorkflowMessage response = null;
                String errorMessage = null;
                Exception error = null;
                boolean isFailed = false;
                try {
                    LOGGER.debug((Object)("Sending HeartBeat Message for " + name));
                    WorkflowMessage heartbeatMessage = MessageSendingHBS.this.constructHeartBeatMessage();
                    RoutingServiceFactory factory = RoutingServiceFactory.newInstance();
                    IRoutingService service = factory.createRoutingService();
                    response = service.send(heartbeatMessage, targetDestinations);
                }
                catch (Exception ex) {
                    isFailed = true;
                    int failureCount = this.consecutiveHeartBeatFailure + 1;
                    errorMessage = "HeartBeat Error for " + name + " when attempting to send message to the Adaptor (Consecutive Error Count=" + failureCount + ").";
                    error = ex;
                }
                if (isFailed) {
                    ++this.consecutiveHeartBeatFailure;
                } else if (MessageSendingHBS.this.isHeartBeatSuccess(response)) {
                    this.consecutiveHeartBeatFailure = 0;
                    event = this.createEvent(null, null);
                    MessageSendingHBS.this.fireHeartBeatSuccessEvent(event);
                } else {
                    ++this.consecutiveHeartBeatFailure;
                    String msg = MessageSendingHBS.this.getErrorMessageInResponse(response);
                    errorMessage = "HeartBeat Error for " + name + ": " + msg;
                }
                if (this.consecutiveHeartBeatFailure >= MessageSendingHBS.this.getHeartBeatFailureThreshold()) {
                    event = this.createEvent(errorMessage, error);
                    MessageSendingHBS.this.fireHeartBeatFailureEvent(event);
                } else if (this.consecutiveHeartBeatFailure > 0) {
                    if (error != null) {
                        LOGGER.warn((Object)errorMessage, (Throwable)error);
                    } else {
                        LOGGER.warn((Object)errorMessage);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Failure in the HeartBeat Monitoring Thread for " + name + ", this should never happen."), (Throwable)ex);
            }
        }

        private ResourceHeartBeatEvent createEvent(String message, Throwable error) {
            ResourceHeartBeatEvent event = null;
            MessageSendingHBS source = MessageSendingHBS.this;
            Resource hbResource = MessageSendingHBS.this.getResource();
            event = new ResourceHeartBeatEvent(source, hbResource, message, error);
            return event;
        }
    }
}

