/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal;

import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.internal.IDistributedServiceTaskExecutor;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class DistributedServiceTaskExecutor
extends ResourceManagementService
implements IDistributedServiceTaskExecutor {
    private static Logger logger = Logger.getLogger(DistributedServiceTaskExecutor.class);

    @Override
    public <R> R runTask(Callable<R> callable, String failureMessage) {
        try {
            return this.runDistributedTask(callable);
        }
        catch (Exception error) {
            this.handleOperationError(failureMessage, error);
            return null;
        }
    }

    @Override
    public <R> R runTask(Callable<R> callable, String failureMessage, Class<? extends Exception> ... permittedErrors) throws Exception {
        try {
            return this.runDistributedTask(callable);
        }
        catch (Exception error) {
            this.handleOperationError(failureMessage, error, permittedErrors);
            return null;
        }
    }

    @Override
    public <R> R runDataOperationTask(Callable<R> callable, String failureMessage) throws DataOperationException {
        try {
            return this.runDistributedTask(callable);
        }
        catch (Exception error) {
            this.handleDataOperationError(failureMessage, error);
            return null;
        }
    }

    @Override
    public <R> R runDataOperationTask(Callable<R> callable, String failureMessage, Class<? extends Exception> ... permittedErrors) throws Exception {
        try {
            return this.runDistributedTask(callable);
        }
        catch (Exception error) {
            this.handleDataOperationError(failureMessage, error, permittedErrors);
            return null;
        }
    }

    @Override
    public <R> Collection<R> runMultiTask(Callable<R> callable, String failureMessage) {
        try {
            return this.runDistributedMultiTask(callable);
        }
        catch (Exception error) {
            this.handleOperationError(failureMessage, error);
            return null;
        }
    }

    @Override
    public <R> Collection<R> runMultiTask(Callable<R> callable, String failureMessage, Class<? extends Exception> ... permittedErrors) throws Exception {
        try {
            return this.runDistributedMultiTask(callable);
        }
        catch (Exception error) {
            this.handleOperationError(failureMessage, error, permittedErrors);
            return null;
        }
    }

    @Override
    public <R> Collection<R> runDataOperationMultiTask(Callable<R> callable, String failureMessage) throws DataOperationException {
        try {
            return this.runDistributedMultiTask(callable);
        }
        catch (Exception error) {
            this.handleDataOperationError(failureMessage, error);
            return null;
        }
    }

    @Override
    public <R> Collection<R> runDataOperationMultiTask(Callable<R> callable, String failureMessage, Class<? extends Exception> ... permittedErrors) throws Exception {
        try {
            return this.runDistributedMultiTask(callable);
        }
        catch (Exception error) {
            this.handleDataOperationError(failureMessage, error, permittedErrors);
            return null;
        }
    }

    @Override
    public RuntimeException wrapError(String failureMessage, Throwable error) {
        if (error instanceof RuntimeException) {
            return (RuntimeException)RuntimeException.class.cast(error);
        }
        String msg = failureMessage + ", error: " + error.getLocalizedMessage();
        return new RuntimeException(msg, error);
    }

    private <R> R runDistributedTask(Callable<R> callable) throws Exception {
        return (R)this.runTask(callable);
    }

    private <R> Collection<R> runDistributedMultiTask(Callable<R> callable) throws Exception {
        long deltaStart = System.currentTimeMillis();
        IDistributedSchedulerService<?> scheduler = this.getDistributedUIScheduler();
        Future future = scheduler.scheduleMulti(callable);
        Collection r = (Collection)future.get();
        logger.debug((Object)("Time taken to runTask from distributed scheduler - time:" + (System.currentTimeMillis() - deltaStart) + " task:" + callable.getClass().getName()));
        return r;
    }

    private <R> Object runTask(Callable<R> callable) throws Exception {
        long deltaStart = System.currentTimeMillis();
        IDistributedSchedulerService<?> scheduler = this.getDistributedUIScheduler();
        Future future = scheduler.schedule(callable);
        Object r = future.get();
        logger.debug((Object)("Time taken to runTask from distributed scheduler - time:" + (System.currentTimeMillis() - deltaStart) + " task:" + callable.getClass().getName()));
        return r;
    }

    private void handleOperationError(String message, Throwable error) {
        try {
            this.handleError(message, error, false, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.wrapError(message, e);
        }
    }

    private void handleOperationError(String message, Throwable error, Class<? extends Exception>[] permittedErrors) throws Exception {
        this.handleError(message, error, false, permittedErrors);
    }

    private void handleDataOperationError(String message, Throwable error) throws DataOperationException {
        try {
            this.handleError(message, error, true, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.wrapError(message, e);
        }
    }

    private void handleDataOperationError(String message, Throwable error, Class<? extends Exception>[] permittedErrors) throws Exception {
        this.handleError(message, error, true, permittedErrors);
    }

    private void handleError(String failureMessage, Throwable error, boolean dataOperation, Class<? extends Exception>[] permittedErrors) throws Exception {
        if (error instanceof InterruptedException) {
            String message = failureMessage + ", operation was interrupted.";
            if (dataOperation) {
                throw new DataOperationException(message, error);
            }
            throw new RuntimeException(message, error);
        }
        if (error instanceof CancellationException) {
            String message = failureMessage + ", operation was cancelled.";
            if (dataOperation) {
                throw new DataOperationException(message, error);
            }
            throw new RuntimeException(message, error);
        }
        if (error instanceof ExecutionException) {
            error = error.getCause();
        }
        if (permittedErrors != null) {
            for (Class<? extends Exception> errorClass : permittedErrors) {
                if (!errorClass.isInstance(error)) continue;
                throw errorClass.cast(error);
            }
        }
        if (error instanceof RuntimeException) {
            throw (RuntimeException)RuntimeException.class.cast(error);
        }
        if (dataOperation && error instanceof DataOperationException) {
            throw (DataOperationException)DataOperationException.class.cast(error);
        }
        throw this.wrapError(failureMessage, error);
    }

    private IDistributedSchedulerService<?> getDistributedUIScheduler() {
        return (IDistributedSchedulerService)this.getService("WFS:ResourceManagementUIScheduler");
    }
}

