/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.event;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.resourcemanager.event.IResourceConsumerAware;
import com.tandbergtv.workflow.resourcemanager.event.ResourceManagementEvent;
import java.util.Date;

public class ResourceAcquiredEvent
extends ResourceManagementEvent
implements IResourceConsumerAware {
    private static final long serialVersionUID = -5385346382420640860L;
    private Resource resource;
    private String taskAssigner = null;
    private ResourceGroupQueueItem item;
    private Date allocationTime;

    public ResourceAcquiredEvent(ResourceGroupQueueItem item, Resource resource, String taskAssigner) {
        this.item = item;
        this.resource = resource;
        this.taskAssigner = taskAssigner;
        this.allocationTime = new Date();
    }

    @Override
    public ResourceConsumerKey getResourceConsumerKey() {
        return this.item.getResourceConsumerKey();
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getAllocatedResourceKey() {
        return this.getResourceConsumerKey().getAllocationKey();
    }

    public String getTaskAssigner() {
        return this.taskAssigner;
    }

    public ResourceGroup getResourceGroup() {
        return this.item.getResourceGroup();
    }

    public Date getStart() {
        return this.item.getQueuedDate();
    }

    public Date getAllocationTime() {
        return this.allocationTime;
    }

    public String toString() {
        return this.getResourceConsumerKey() + ", event RESOURCE_ACQUIRED";
    }
}

