/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resource;

import com.tandbergtv.workflow.core.health.ComponentHealthStatus;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.IResourceService;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IDistributedServiceTaskExecutor;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.resource.CreateResourceCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.DeleteResourceCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetAllResourcesCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourceByConnectionStringCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourceByNameCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourceByTokenCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourceByUserCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourceCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourcesByGroupCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourcesByGroupNameCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.GetResourcesByResourceTypeCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.SetResourceOfflineCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.SetResourceOnlineCallable;
import com.tandbergtv.workflow.resourcemanager.internal.resource.UpdateResourceCallable;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class DistributedResourceService
extends ResourceManagementService
implements IResourceManagementService,
IResourceService {
    private static final Logger LOGGER = Logger.getLogger(DistributedResourceService.class);

    @Override
    public List<Resource> getAllResources() {
        GetAllResourcesCallable callable = new GetAllResourcesCallable();
        String failureMessage = "Failed to get all resources";
        Collection<List<Resource>> allResults = this.getDistributedExecutor().runMultiTask(callable, failureMessage);
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        if (allResults != null) {
            for (List<Resource> result : allResults) {
                if (result == null) continue;
                resourceList.addAll(result);
            }
        }
        return resourceList;
    }

    @Override
    public List<Resource> getResourcesBySearchCriteria(SearchCriteria searchCriteria) throws DataOperationException {
        List<Resource> resourceList = null;
        ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
        Session session = this.getPersistenceService().getCurrentSession();
        this.getPersistenceService().beginTransaction(session);
        try {
            resourceList = dao.findBySearchCriteria(searchCriteria);
            this.getPersistenceService().commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            throw new DataOperationException("Failed to get the list of Resources from the Database.", ex);
        }
        return resourceList;
    }

    @Override
    public int getActiveResourcesCount() {
        int count = 0;
        ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
        Session session = this.getPersistenceService().getCurrentSession();
        this.getPersistenceService().beginTransaction(session);
        try {
            count = dao.countByActive();
            this.getPersistenceService().commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            throw new RuntimeException("Failed to get the count of active resources from the database.", ex);
        }
        return count;
    }

    @Override
    public Resource getResource(long resourceId) throws FinderException, DataOperationException {
        long start = System.currentTimeMillis();
        Resource resource = null;
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResource(resourceId);
        if (resourceTypeId == null) {
            Session session = this.getPersistenceService().getCurrentSession();
            DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
            ResourceDAI dao = factory.getResourceDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                resource = (Resource)dao.findByKey(resourceId);
                resource = this.getCloneService().cloneResource(resource);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException ex) {
                this.getPersistenceService().rollbackTransaction(session);
                throw new DataOperationException("Failed to get the Resource[" + resourceId + "] from the Database.", ex);
            }
        }
        GetResourceCallable callable = new GetResourceCallable(resourceTypeId, resourceId);
        String failureMessage = "Failed to get resource[" + resourceId + "]";
        try {
            resource = this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, FinderException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
        LOGGER.debug((Object)("Time taken to allocate a reource [resourceId:" + resourceId + "] - time:" + (System.currentTimeMillis() - start)));
        return resource;
    }

    @Override
    public Resource getResourceByName(String resourceName) throws FinderException, DataOperationException {
        long start = System.currentTimeMillis();
        Resource resource = null;
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResourceName(resourceName);
        if (resourceTypeId == null) {
            Session session = this.getPersistenceService().getCurrentSession();
            DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
            ResourceDAI dao = factory.getResourceDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                resource = dao.findByName(resourceName);
                resource = this.getCloneService().cloneResource(resource);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException ex) {
                this.getPersistenceService().rollbackTransaction(session);
                throw new DataOperationException("Failed to get the Resource[" + resourceName + "] from the Database.", ex);
            }
        }
        GetResourceByNameCallable callable = new GetResourceByNameCallable(resourceTypeId, resourceName);
        String failureMessage = "Failed to get resource[" + resourceName + "]";
        try {
            resource = this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, FinderException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
        LOGGER.debug((Object)("Time taken to get a resource [resourceName:" + resourceName + "] - time:" + (System.currentTimeMillis() - start)));
        return resource;
    }

    @Override
    public List<Resource> getResourcesByResourceType(long resourceTypeId) {
        GetResourcesByResourceTypeCallable callable = new GetResourcesByResourceTypeCallable(resourceTypeId);
        String failureMessage = "Failed to get resources by type[" + resourceTypeId + "]";
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public List<Resource> getResourcesBySystemId(String systemId) {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForDevice(systemId);
        return resourceTypeId != null ? this.getResourcesByResourceType(resourceTypeId) : new ArrayList();
    }

    @Override
    public List<Resource> getResourcesByGroup(long resourceGroupId) {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId);
        if (resourceTypeId == null) {
            return new ArrayList<Resource>();
        }
        GetResourcesByGroupCallable callable = new GetResourcesByGroupCallable(resourceTypeId, resourceGroupId);
        String failureMessage = "Failed to get resources by group[" + resourceGroupId + "]";
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public List<Resource> getResourcesByGroupName(String resourceGroupName) {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForGroupName(resourceGroupName);
        if (resourceTypeId == null) {
            return new ArrayList<Resource>();
        }
        GetResourcesByGroupNameCallable callable = new GetResourcesByGroupNameCallable(resourceTypeId, resourceGroupName);
        String failureMessage = "Failed to get resources by group[" + resourceGroupName + "]";
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public Resource getResourceByToken(long tokenId) {
        GetResourceByTokenCallable callable = new GetResourceByTokenCallable(tokenId);
        String failureMessage = "Failed to get resource for token " + tokenId;
        Collection<Resource> resources = this.getDistributedExecutor().runMultiTask(callable, failureMessage);
        if (resources != null) {
            for (Resource resource : resources) {
                if (resource == null) continue;
                return resource;
            }
        }
        return null;
    }

    @Override
    public Resource getResourceByUser(String userName) {
        if (userName == null) {
            return null;
        }
        Long resourceTypeId = null;
        IHibernatePersistenceService service = this.getPersistenceService();
        Session session = this.getPersistenceService().getCurrentSession();
        DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
        ResourceDAI dao = factory.getResourceDAO();
        service.beginTransaction(session);
        try {
            resourceTypeId = dao.findResourceTypeIDByUserName(userName);
            service.commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            throw new RuntimeException("Failed to get the Resource for user[ " + userName + "] from the Database.", ex);
        }
        if (resourceTypeId == null) {
            return null;
        }
        GetResourceByUserCallable callable = new GetResourceByUserCallable(resourceTypeId, userName);
        String failureMessage = "Failed to get resource for user " + userName;
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public Resource getResourceByConnectionString(String connectionString) {
        return this.getResourceByConnectionStringInternal(connectionString, null);
    }

    @Override
    public Resource getResourceByConnectionString(String connectionString, long groupId) {
        return this.getResourceByConnectionStringInternal(connectionString, groupId);
    }

    private Resource getResourceByConnectionStringInternal(String connectionString, Long groupId) {
        if (connectionString == null) {
            return null;
        }
        Long resourceTypeId = null;
        IHibernatePersistenceService service = this.getPersistenceService();
        Session session = this.getPersistenceService().getCurrentSession();
        DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
        ResourceDAI dao = factory.getResourceDAO();
        service.beginTransaction(session);
        try {
            resourceTypeId = dao.findResourceTypeIDByConnectionString(connectionString);
            service.commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            throw new RuntimeException("Failed to get the Resource for connection string[ " + connectionString + "] from the Database.", ex);
        }
        if (resourceTypeId == null) {
            return null;
        }
        GetResourceByConnectionStringCallable callable = new GetResourceByConnectionStringCallable(resourceTypeId, connectionString, groupId);
        String failureMessage = "Failed to get resource for connection string " + connectionString;
        return this.getDistributedExecutor().runTask(callable, failureMessage);
    }

    @Override
    public Resource setResourceOnline(long resourceId) throws FinderException, DataOperationException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResource(resourceId);
        if (resourceTypeId == null) {
            String msg = "Could not set Resource with id=" + resourceId + " Online, no such Resource exists.";
            throw new FinderException(msg);
        }
        SetResourceOnlineCallable callable = new SetResourceOnlineCallable(resourceTypeId, resourceId);
        String failureMessage = "Failed to set resource[" + resourceId + "] online";
        try {
            return this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, FinderException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
    }

    @Override
    public Resource setResourceOffline(long resourceId) throws FinderException, DataOperationException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResource(resourceId);
        if (resourceTypeId == null) {
            String msg = "Could not set Resource with id=" + resourceId + " Offline, no such Resource exists.";
            throw new FinderException(msg);
        }
        SetResourceOfflineCallable callable = new SetResourceOfflineCallable(resourceTypeId, resourceId);
        String failureMessage = "Failed to set resource[" + resourceId + "] offline";
        try {
            return this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, FinderException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
    }

    @Override
    public Resource createResource(Resource resource) throws ValidationException, DataOperationException {
        if (resource.getResourceType() == null) {
            ValidationException ve = new ValidationException();
            ve.addErrorCode("VR-101");
            throw ve;
        }
        CreateResourceCallable callable = new CreateResourceCallable(resource);
        String failureMessage = "Failed to create resource";
        try {
            return this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, ValidationException.class, DataOperationException.class);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
    }

    @Override
    public Resource updateResource(Resource resource) throws ValidationException, ActionException, FinderException, DataOperationException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResource(resource.getId());
        if (resourceTypeId == null) {
            String msg = "Failed to update Resource with id=" + resource.getId() + ", no such Resource exists.";
            throw new FinderException(msg);
        }
        UpdateResourceCallable callable = new UpdateResourceCallable(resourceTypeId, resource);
        String failureMessage = "Failed to update resource" + resource;
        try {
            return this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, FinderException.class, ActionException.class, ValidationException.class, DataOperationException.class);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (ActionException e) {
            throw e;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
    }

    @Override
    public boolean deleteResource(long resourceId) throws ActionException, DataOperationException {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForResource(resourceId);
        if (resourceTypeId == null) {
            return false;
        }
        DeleteResourceCallable callable = new DeleteResourceCallable(resourceTypeId, resourceId);
        String failureMessage = "Failed to delete resource[" + resourceId + "]";
        try {
            return this.getDistributedExecutor().runDataOperationTask(callable, failureMessage, ActionException.class, DataOperationException.class);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (DataOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getDistributedExecutor().wrapError(failureMessage, e);
        }
    }

    @Override
    public boolean isResourceActive(long resourceId) {
        boolean active = false;
        Session session = this.getPersistenceService().getCurrentSession();
        ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
        this.getPersistenceService().beginTransaction(session);
        try {
            active = dao.isActive(resourceId);
            this.getPersistenceService().commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            throw ex;
        }
        return active;
    }

    @Override
    public IAllocationKeyService getAllocationKeyService() {
        return this.getLocalResourceService().getAllocationKeyService();
    }

    @Override
    public ComponentHealthStatus getHealthStatus() {
        int errorCount = 0;
        IHibernatePersistenceService service = this.getPersistenceService();
        Session session = this.getPersistenceService().getCurrentSession();
        DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
        ResourceDAI dao = factory.getResourceDAO();
        service.beginTransaction(session);
        try {
            errorCount = dao.countByErrorStates();
            service.commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            String msg = "Failed to get count of resources with error states from the Database.";
            throw new RuntimeException(msg, ex);
        }
        return errorCount > 0 ? ComponentHealthStatus.ERROR : ComponentHealthStatus.OK;
    }

    @Override
    public String getServiceName() {
        return "DistributedResourceService";
    }

    private IResourceService getLocalResourceService() {
        return (IResourceService)this.getService("LocalResourceService");
    }

    private IHibernatePersistenceService getPersistenceService() {
        return this.getService(IHibernatePersistenceService.class);
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }

    private IDistributedServiceTaskExecutor getDistributedExecutor() {
        return this.getService(IDistributedServiceTaskExecutor.class);
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }
}

