/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupQueueSampler;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupCreatedEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.IResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.container.BaseContainer;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultKeyBasedAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.MostRemainingConnectionsResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.RoundRobinResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoadException;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class ResourceGroupContainer
extends BaseContainer<ResourceGroup> {
    private static final long serialVersionUID = 4829085370756312184L;
    private static final Logger LOGGER = Logger.getLogger(ResourceGroupContainer.class);
    private static final String MBEAN_NAME = "com.tandbergtv.watchpoint:type=Queue,name=Resource Group ";
    private static final int DEFAULT_WAIT_TIMEOUT = 120;
    private ISchedulerService<Void> queueProcessor;
    private ResourceAllocationStrategy allocationStrategy;
    private QueueAllocationCallable allocationTask;
    private boolean notified = false;
    private long timeout = 0L;

    public ResourceGroupContainer(ResourceGroup resourceGroup) {
        super(resourceGroup);
    }

    public ResourceGroup getResourceGroup() {
        return (ResourceGroup)this.getEntity();
    }

    public ResourceAllocationStrategy getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public String toString() {
        return "resource group" + ((ResourceGroup)this.getEntity()).toString();
    }

    private void initializeStrategy(ResourceGroupDescriptor descriptor) {
        boolean allocationStrategyClassLoaded = false;
        String reason = "";
        String resourceGroupName = ((ResourceGroup)this.getEntity()).getName();
        if (descriptor == null) {
            reason = "No descriptor defined.";
        } else if (descriptor.getAllocationStrategyClass() == null) {
            reason = "AllocationStrategyClass is not defined.";
        } else if (descriptor.getClassLoader() == null) {
            reason = "Plugin ClassLoader is null.";
        } else {
            try {
                this.allocationStrategy = StrategyClassLoader.loadAllocationStrategy(descriptor.getAllocationStrategyClass(), descriptor.getClassLoader());
                allocationStrategyClassLoaded = true;
            }
            catch (StrategyClassLoadException scle) {
                reason = "Failed to load the Resource Allocation Strategy class";
                LOGGER.error((Object)reason, (Throwable)scle);
            }
        }
        if (!allocationStrategyClassLoaded) {
            LOGGER.debug((Object)("Using the Default Resource Allocation Strategy for: " + resourceGroupName + " | " + reason));
            this.allocationStrategy = StrategyClassLoader.createDefaultResourceAllocationStrategy();
        }
        this.timeout = (long)this.getQueueWaitTimeout() * 1000L;
    }

    private int getQueueWaitTimeout() {
        String systemId;
        ResourceType resourceType = ((ResourceGroup)this.getEntity()).getResourceType();
        String string = systemId = resourceType != null ? resourceType.getSystemId() : null;
        if ("04".equals(systemId)) {
            return 0;
        }
        List<Class<?>> classes = this.getOutOfBoxAllocationStrategyClasses();
        if (classes.contains(this.allocationStrategy.getClass())) {
            return 0;
        }
        int queueTimeout = 120;
        String value = null;
        try {
            value = System.getProperty("com.tandbergtv.workflow.resourcemanager.queueWaitTimeoutSeconds");
            if (value != null && !value.trim().isEmpty()) {
                queueTimeout = Integer.parseInt(value.trim());
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (queueTimeout < 0) {
            queueTimeout = 0;
        }
        if (queueTimeout > 0 && queueTimeout < 120) {
            LOGGER.warn((Object)("[com.tandbergtv.workflow.resourcemanager.queueWaitTimeoutSeconds] system property has invalid value[" + value + "]. Value must be 0 or >= " + 120 + ", using default value[" + 120 + "] instead."));
            queueTimeout = 120;
        }
        return queueTimeout;
    }

    private List<Class<?>> getOutOfBoxAllocationStrategyClasses() {
        ArrayList classes = new ArrayList();
        classes.add(DefaultResourceAllocationStrategy.class);
        classes.add(DefaultKeyBasedAllocationStrategy.class);
        classes.add(MostRemainingConnectionsResourceAllocationStrategy.class);
        classes.add(RoundRobinResourceAllocationStrategy.class);
        return classes;
    }

    @Override
    public void initialize() {
        PluginManagement manager = (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
        String name = ((ResourceGroup)this.getEntity()).getName();
        this.initializeStrategy(manager.getResourceGroupDescriptor(name));
    }

    @Override
    protected void doStart() {
        this.registerMBean();
        if (this.isQueueProcessorRequired()) {
            this.startQueueProcessor();
        }
        if (((ResourceGroup)this.getEntity()).isSendCreatedEvent()) {
            ((ResourceGroup)this.getEntity()).setSendCreatedEvent(false);
            ICloneService service = this.getService(ICloneService.class);
            ResourceGroup clone = service.cloneResourceGroup((ResourceGroup)this.getEntity());
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ResourceGroupCreatedEvent(clone));
            this.updateEntity();
        }
    }

    @Override
    protected void doStop() {
        this.stopQueueProcessor();
        this.unregisterMBean();
    }

    @Override
    protected void writeToDistributedCache() {
        IMultiValueCacheService cache = (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
        ICloneService cloneService = this.getService(ICloneService.class);
        cache.add((Serializable)this.getResourceTypeId(), (Object)cloneService.cloneResourceGroup((ResourceGroup)this.getEntity()));
    }

    @Override
    protected void writeToPersistenceStore() {
        IHibernatePersistenceService service = this.getService(IHibernatePersistenceService.class);
        SessionFactory factory = service.getSessionFactory();
        Session session = factory.getCurrentSession();
        ResourceGroupDAI dao = service.getDataAccessObjectFactory().getResourceGroupDAO();
        ICloneService cloneService = this.getService(ICloneService.class);
        ResourceGroup clone = cloneService.cloneResourceGroup((ResourceGroup)this.getEntity(), false);
        service.beginTransaction((org.hibernate.Session)session);
        try {
            dao.update(clone);
            service.commitTransaction((org.hibernate.Session)session);
        }
        catch (RuntimeException ex) {
            service.rollbackTransaction((org.hibernate.Session)session);
            String msg = "Failed to internally update ResourceGroup[id=" + this.getKey() + "]: " + ((ResourceGroup)this.getEntity()).getName() + ", the object in memory is different from the DB.";
            LOGGER.error((Object)msg, (Throwable)ex);
        }
    }

    @Override
    public Serializable getKey() {
        return Long.valueOf(((ResourceGroup)this.getEntity()).getId());
    }

    @Override
    public Long getResourceTypeId() {
        return ((ResourceGroup)this.getEntity()).getResourceType().getId();
    }

    private void startQueueProcessor() {
        if (this.queueProcessor == null) {
            LOGGER.debug((Object)("Starting Queue Processing Thread for " + this));
            this.queueProcessor = new Scheduler("Queue-Processor-" + this.getKey());
            this.queueProcessor.start();
            this.allocationTask = new QueueAllocationCallable();
            this.queueProcessor.schedule((Callable)this.allocationTask);
        }
    }

    private void stopQueueProcessor() {
        if (this.queueProcessor != null) {
            LOGGER.debug((Object)("Stopping Queue Processing Thread for " + this));
            this.allocationTask.stopQueueProcessing();
            this.queueProcessor.stop();
            this.allocationTask = null;
            this.queueProcessor = null;
        }
    }

    private boolean isQueueProcessorRequired() {
        boolean required = false;
        if (((ResourceGroup)this.getEntity()).isInternallyAcquired() && !((ResourceGroup)this.getEntity()).isConsumerTracingDisabled()) {
            ICacheService cache = (ICacheService)this.getService("WFS:ResourceTypeCache");
            ResourceType resourceType = (ResourceType)cache.get((Serializable)this.getResourceTypeId());
            required = resourceType.isAvailable();
        }
        return required;
    }

    public synchronized void notifyQueue() {
        if (this.queueProcessor != null) {
            LOGGER.debug((Object)("Signaling " + this + " to attempt to process the Queue."));
        }
        this.notifyAll();
        this.notified = true;
    }

    private synchronized void waitForQueueNotification() {
        if (!this.notified) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException ex) {
                LOGGER.debug((Object)("Resource Group Queue Processing Thread for " + this + " was interrupted while waiting for event notification."));
            }
        }
        this.notified = false;
        LOGGER.debug((Object)("Received notification to process the Queue for " + this));
    }

    private boolean performAllocation() {
        IResourceAllocationService service = this.getService(IResourceAllocationService.class);
        return service.performInternalAllocation(((ResourceGroup)this.getEntity()).getId());
    }

    public void performMaintenance(ResourceGroupDescriptor descriptor, ResourceGroup group) {
        ((ResourceGroup)this.getEntity()).setFunctionalType(group.getFunctionalType());
        ((ResourceGroup)this.getEntity()).setProtectionKeyId(group.getProtectionKeyId());
        this.updateEntity();
        this.initializeStrategy(descriptor);
        if (this.isQueueProcessorRequired()) {
            this.startQueueProcessor();
        } else {
            this.stopQueueProcessor();
        }
    }

    public void performMaintenance(ResourceTypeDescriptor descriptor) {
        if (this.isQueueProcessorRequired()) {
            this.startQueueProcessor();
        } else {
            this.stopQueueProcessor();
        }
    }

    public String getMBeanName() {
        return MBEAN_NAME + ((ResourceGroup)this.getEntity()).getName();
    }

    private void registerMBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ResourceGroupQueueSampler monitor = new ResourceGroupQueueSampler(this);
        try {
            StandardMBean mbean = new StandardMBean(monitor, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(this.getMBeanName()));
        }
        catch (JMException e) {
            LOGGER.warn((Object)("MBean registration for group " + ((ResourceGroup)this.getEntity()).getName() + " failed"), (Throwable)e);
        }
    }

    private void unregisterMBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    private class QueueAllocationCallable
    implements Callable<Void> {
        private final AtomicBoolean queueProcessing = new AtomicBoolean(true);

        private QueueAllocationCallable() {
        }

        private boolean isQueueProcessing() {
            return this.queueProcessing.get();
        }

        private void stopQueueProcessing() {
            this.queueProcessing.set(false);
        }

        @Override
        public Void call() throws Exception {
            String container = ResourceGroupContainer.this.toString();
            LOGGER.debug((Object)("Starting Queue Processing Thread for " + container));
            while (this.isQueueProcessing()) {
                try {
                    long start = System.currentTimeMillis();
                    boolean allocated = ResourceGroupContainer.this.performAllocation();
                    if (allocated) {
                        long duration = System.currentTimeMillis() - start;
                        LOGGER.debug((Object)("Allocation for " + container + " in " + duration + " ms"));
                    }
                    if (allocated || !this.isQueueProcessing()) continue;
                    LOGGER.debug((Object)("Waiting for notification of a new Resource / Queue Item becoming available for " + container));
                    ResourceGroupContainer.this.waitForQueueNotification();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Error in the Queue Processing Thread for " + container + ", ignoring the error and continuing."), (Throwable)e);
                }
            }
            LOGGER.debug((Object)("Queue Processing Thread for " + container + " has ended."));
            return null;
        }
    }
}

