/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.Date;

public class ResourceGroupQueueItem
implements ResourceEntity {
    private static final long serialVersionUID = 2688779597465739871L;
    private int orderNumber;
    private Date queuedDate;
    private Date queueOrderDate;
    private long tokenId;
    private ResourceGroup resourceGroup;
    private ProcessPriority priority;
    private ResourceConsumerKey consumer;
    private static final int HASHCODE_MULTIPLICATION_FACTOR = 3;
    private static final int HASHCODE_ADDITION_FACTOR = 37;

    public ResourceGroupQueueItem() {
        this.queueOrderDate = this.queuedDate = new Date();
        this.tokenId = -1L;
    }

    public ResourceGroupQueueItem(long queueItemId) {
        this.queueOrderDate = this.queuedDate = new Date();
        this.tokenId = -1L;
        this.tokenId = queueItemId;
    }

    public ResourceGroupQueueItem(ResourceConsumerKey key) {
        this.queueOrderDate = this.queuedDate = new Date();
        this.tokenId = -1L;
        this.consumer = key;
        this.tokenId = key.getId();
        this.priority = key.getPriority();
    }

    public ResourceConsumerKey getResourceConsumerKey() {
        return this.consumer;
    }

    public long getId() {
        return this.tokenId;
    }

    @Deprecated
    void setId(long id) {
    }

    @Deprecated
    public int getOrderNumber() {
        return this.orderNumber;
    }

    @Deprecated
    public void setOrderNumber(int orderNumber) {
    }

    public Date getQueuedDate() {
        return this.queuedDate;
    }

    public void setQueuedDate(Date queuedDate) {
        this.queuedDate = queuedDate;
    }

    public Date getQueueOrderDate() {
        return this.queueOrderDate;
    }

    public void setQueueOrderDate(Date date) {
        this.queueOrderDate = date;
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    @Deprecated
    public void setTokenId(long tokenId) {
    }

    public String getAllocationKey() {
        return this.consumer.getAllocationKey();
    }

    @Deprecated
    public void setAllocationKey(String allocationKey) {
    }

    public ProcessPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProcessPriority priority) {
        this.priority = priority;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceGroupQueueItem) {
            ResourceGroupQueueItem resObj = (ResourceGroupQueueItem)obj;
            if (resObj.getId() != -1L && this.getId() != -1L) {
                return resObj.getId() == this.getId();
            }
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        long hash = this.getId() * 3L + 37L;
        int hashCode = new Long(hash).hashCode();
        if (this.getId() == -1L) {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    @Override
    public Object clone() {
        ResourceGroupQueueItem clone = null;
        try {
            clone = (ResourceGroupQueueItem)super.clone();
            if (this.queuedDate != null) {
                clone.queuedDate = (Date)this.queuedDate.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String toString() {
        return "" + this.getId();
    }
}

