/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.google.common.base.Stopwatch;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.internal.CacheUpdateEvent;
import com.tandbergtv.workflow.core.service.internal.IUpdatePolicy;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ReplicatedSimpleCache<T>
extends CacheService<T> {
    private static final Logger LOGGER = Logger.getLogger(ReplicatedSimpleCache.class);
    private IClusterService clusterService;
    private ITopic<CacheUpdateEvent> clusterTopic;
    private IUpdatePolicy<T> updatePolicy;

    public ReplicatedSimpleCache(String topicName) {
        this(topicName, 8192);
    }

    public ReplicatedSimpleCache(String topicName, int size) {
        this(topicName, size, null);
    }

    public ReplicatedSimpleCache(String topicName, int size, IUpdatePolicy<T> updatePolicy) {
        super(topicName, size);
        this.clusterTopic = this.getClusterService().getInstance().getTopic(topicName);
        this.updatePolicy = updatePolicy;
        this.clusterTopic.addMessageListener((MessageListener)new CacheUpdateListener());
    }

    public void setUpdatePolicy(IUpdatePolicy<T> updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    @Override
    public void add(Serializable key, T entity) {
        this.cacheWithLocalOnly(key, entity);
        this.notifyChanging(key, 1);
    }

    public void add(Serializable key, T entity, boolean notifyChangeCluster) {
        this.cacheWithLocalOnly(key, entity);
        if (notifyChangeCluster) {
            this.notifyChanging(key, 1);
        }
    }

    private void cacheWithLocalOnly(Serializable key, T entity) {
        super.add(key, entity);
    }

    @Override
    public void remove(Serializable key) {
        this.uncache(key);
        this.notifyChanging(key, 0);
    }

    private void uncache(Serializable key) {
        super.remove(key);
    }

    public void notifyChanging(Serializable key, int type) {
        this.clusterTopic.publish((Object)new CacheUpdateEvent(this.getLocalNodeAddress(), key, type));
    }

    private InetSocketAddress getLocalNodeAddress() {
        return this.getClusterService().getInstance().getCluster().getLocalMember().getSocketAddress();
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    private final class CacheUpdateListener
    implements MessageListener<CacheUpdateEvent> {
        private CacheUpdateListener() {
        }

        public void onMessage(Message<CacheUpdateEvent> message) {
            Serializable key;
            if (this.isSelfNode((CacheUpdateEvent)message.getMessageObject())) {
                LOGGER.debug((Object)("Ignore the Update since the message is from itself:" + message.getMessageObject()));
                return;
            }
            Serializable serializable = key = message.getMessageObject() != null ? ((CacheUpdateEvent)message.getMessageObject()).getId() : null;
            if (((CacheUpdateEvent)message.getMessageObject()).isReloadEvent()) {
                this.handleReloadEvent(key);
            }
            if (((CacheUpdateEvent)message.getMessageObject()).isRemovedEvent()) {
                this.handleRemoveEvent(key);
            }
        }

        private void handleRemoveEvent(Serializable key) {
            String object = "" + ReplicatedSimpleCache.this.get(key);
            LOGGER.info((Object)("Remove the cache [" + object + "] in " + ReplicatedSimpleCache.this.getServiceName() + " by delete event for key:[" + key + "]"));
            ReplicatedSimpleCache.this.uncache(key);
        }

        private void handleReloadEvent(Serializable key) {
            LOGGER.debug((Object)("try to Update the cache by reload event for key: [" + key + "]"));
            if (ReplicatedSimpleCache.this.updatePolicy == null) {
                LOGGER.warn((Object)("Cannot find UpdatePolicy for current cache object:" + ReplicatedSimpleCache.this.getServiceName()));
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            Object t = ReplicatedSimpleCache.this.updatePolicy.reloadEntity(key);
            ReplicatedSimpleCache.this.cacheWithLocalOnly(key, t);
            stopwatch.stop();
            LOGGER.info((Object)("Update the cache [" + t + "] in " + ReplicatedSimpleCache.this.getServiceName() + " by reload event for key:[" + key + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }

        private boolean isSelfNode(CacheUpdateEvent message) {
            return ReplicatedSimpleCache.this.getClusterService().isLocalMember(message.getEventSourceAddress());
        }
    }
}

