/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IQueue;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class DistributedQueueService<T>
implements IDistributedQueueService<T> {
    private static final Logger logger = Logger.getLogger(DistributedQueueService.class);
    private String name;

    public DistributedQueueService(String name) {
        this.name = name;
    }

    @Override
    public BlockingQueue<T> getQueue(String name) {
        return Hazelcast.getQueue((String)name);
    }

    @Override
    public void removeQueue(String name) {
        long start = System.currentTimeMillis();
        ((IQueue)this.getQueue(name)).destroy();
        logger.debug((Object)("Time taken to getQueue().destroy() - time:" + (System.currentTimeMillis() - start) + " - name:" + name));
        start = System.currentTimeMillis();
        Hazelcast.getMap((String)("q:" + name)).destroy();
        logger.debug((Object)("Time taken to getMap().destroy() - time:" + (System.currentTimeMillis() - start) + " - name:q:" + name));
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

