/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.IQueue;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import java.util.concurrent.BlockingQueue;

public class DistributedQueueService<T>
implements IDistributedQueueService<T> {
    private String name;
    private IClusterService clusterService;

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    public DistributedQueueService(String name) {
        this.name = name;
    }

    @Override
    public BlockingQueue<T> getQueue(String name) {
        return this.getClusterService().getInstance().getQueue(name);
    }

    @Override
    public void removeQueue(String name) {
        ((IQueue)this.getQueue(name)).destroy();
        this.getClusterService().getInstance().getMap("q:" + name).destroy();
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

