/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resource.test;

import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.test.SequentialTestBase;
import com.tandbergtv.workflow.test.util.TestUtil;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ResourceCRUD
extends SequentialTestBase {
    ResourceManagement resourceManager;
    String resourceName = "ResourceCRUD";
    String connectionString = "http://localhost:135792468";
    int concurrency = 1;
    boolean ignoreTimeout = false;
    ResourceState adminState = ResourceState.ONLINE;

    @BeforeClass
    public void setup() throws Exception {
        this.resourceManager = TestUtil.getResourceManagement();
        for (Resource leftoverResource : this.resourceManager.getResourcesBySystemId("27")) {
            if (!leftoverResource.getName().contains(this.resourceName)) continue;
            this.resourceManager.setResourceOffline(leftoverResource.getId());
            this.resourceManager.deleteResource(leftoverResource.getId());
        }
    }

    @Test(priority=1)
    public void createResource() throws Exception {
        Resource resource = this.setNewResourceParameters();
        this.resourceManager.createResource(resource);
        resource = this.refreshResource();
        ResourceCRUD.assertEquals((Object)resource.getOperationalState(), (Object)ResourceState.ONLINE);
    }

    @Test(dependsOnMethods={"createResource"}, priority=2)
    public void readResource() {
        Resource resource = this.setNewResourceParameters();
        this.assertResourceMatchesStoredResource(resource);
    }

    @Test(dependsOnMethods={"createResource"}, priority=3)
    public void modifyOnlineResource() throws Exception {
        Resource originalResource = this.refreshResource();
        Resource changedResource = this.refreshResource();
        changedResource.setName(this.resourceName + "1");
        try {
            this.resourceManager.updateResource(changedResource);
        }
        catch (ActionException e) {
            ResourceCRUD.assertTrue((boolean)e.getErrorCode().equals("AE-102"));
        }
        this.assertResourceMatchesStoredResource(originalResource);
    }

    @Test(dependsOnMethods={"createResource"}, priority=4)
    public void modifyOfflineResource() throws Exception {
        Resource resource = this.refreshResource();
        this.resourceManager.setResourceOffline(resource.getId());
        resource.setName(this.resourceName + "2");
        this.resourceManager.updateResource(resource);
        this.assertResourceMatchesStoredResource(resource);
        this.resourceManager.setResourceOnline(resource.getId());
    }

    @Test(dependsOnMethods={"createResource"}, priority=5)
    public void deleteOnlineResource() throws Exception {
        Resource resource = this.refreshResource();
        try {
            this.resourceManager.deleteResource(resource.getId());
        }
        catch (ActionException e) {
            ResourceCRUD.assertTrue((boolean)e.getErrorCode().equals("AE-102"));
        }
        this.refreshResource();
        ResourceCRUD.assertNotNull((Object)resource);
    }

    @Test(dependsOnMethods={"createResource"}, priority=6)
    public void deleteOfflineResource() throws Exception {
        Resource resource = this.refreshResource();
        this.resourceManager.setResourceOffline(resource.getId());
        this.resourceManager.deleteResource(resource.getId());
        resource = this.refreshResource();
        ResourceCRUD.assertNull((Object)resource);
    }

    private Resource refreshResource() {
        return this.resourceManager.getResourceByConnectionString(this.connectionString);
    }

    private Resource setNewResourceParameters() {
        Resource exampleResource = (Resource)this.resourceManager.getResourcesBySystemId("27").get(0);
        Resource resource = new Resource();
        resource.setResourceType(exampleResource.getResourceType());
        resource.setResourceGroups(exampleResource.getResourceGroups());
        resource.setName(this.resourceName);
        resource.setConnectionString(this.connectionString);
        resource.setHeartbeatConnectionString(null);
        resource.setHeartbeatFrequency(null);
        resource.setMaxConcurrentUsers(this.concurrency);
        resource.setIgnoreTimeout(this.ignoreTimeout);
        resource.setAdministrationState(this.adminState);
        return resource;
    }

    private void assertResourceMatchesStoredResource(Resource resource) {
        Resource readResource = this.refreshResource();
        ResourceCRUD.assertEquals((String)readResource.getName(), (String)resource.getName());
        ResourceCRUD.assertEquals((String)readResource.getConnectionString(), (String)resource.getConnectionString());
        ResourceCRUD.assertEquals((int)readResource.getMaxConcurrentUsers(), (int)resource.getMaxConcurrentUsers());
        ResourceCRUD.assertEquals((boolean)readResource.getIgnoreTimeout(), (boolean)resource.getIgnoreTimeout());
        ResourceCRUD.assertEquals((Object)readResource.getAdministrationState(), (Object)resource.getAdministrationState());
    }
}

