/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.actionitems.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.monitor.core.alarm.IntentOperation;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.RestClient;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class RecoverySupport
extends Assert {
    private static long timeoutMillisecs = 20000L;
    private static final Logger logger = Logger.getLogger(RecoverySupport.class);
    private static String ip = "localhost";
    private static String port = "8443";
    private static String baseURI = "https://" + ip + ":" + port;
    private static String alarmsGetPrefix = "/workflow/alarms?startTime=";
    private static String processPostPrefix = "/workflow/process/";
    protected List<WorkflowProcess> createdProcesses = new ArrayList<WorkflowProcess>();
    private static final long userTaskTimeout = 70000L;

    @AfterMethod
    public void afterMethod() throws Exception {
        this.createdProcesses.clear();
    }

    @Test
    public void cancelActionTest() throws Exception {
        String action = IntentOperation.Cancel.toString();
        WorkflowProcess control = ProcessUtils.create("UserTaskTemplate", this.createdProcesses);
        WorkflowProcess wp = ProcessUtils.create("UserTaskTemplate", this.createdProcesses);
        ProcessUtils.sleepWhileActive(this.createdProcesses, timeoutMillisecs);
        this.postAction("admin", "admin", wp.getId(), action, 202);
        ProcessUtils.assertStatus(wp.getId(), ProcessStatus.CANCELLED, timeoutMillisecs);
        ProcessUtils.assertStatus(control.getId(), ProcessStatus.BUSY, timeoutMillisecs);
        this.negativeActionTests(wp.getId(), action);
    }

    @Test
    public void restartActionTest() throws Exception {
        String action = IntentOperation.Restart.toString();
        WorkflowProcess control = ProcessUtils.create("UserTaskTemplate", this.createdProcesses);
        WorkflowProcess wp = ProcessUtils.create("UserTaskTemplate", this.createdProcesses);
        ProcessUtils.sleepWhileActive(this.createdProcesses, timeoutMillisecs);
        this.postAction("admin", "admin", wp.getId(), action, 202);
        logger.info((Object)("Taking Action " + action + " for WO #" + wp.getId()));
        ProcessUtils.assertStatus(control.getId(), ProcessStatus.BUSY, timeoutMillisecs);
        ProcessUtils.assertStatus(wp.getId(), ProcessStatus.CANCELLED, timeoutMillisecs);
        Thread.sleep(timeoutMillisecs);
        int k = 0;
        while (k < 200) {
            try {
                ProcessUtils.get(wp.getId() + (long)(++k)).getRootToken().getStatus();
                break;
            }
            catch (Exception exception) {
            }
        }
        ProcessUtils.assertStatus(wp.getId() + (long)k, ProcessStatus.BUSY, timeoutMillisecs);
        this.negativeActionTests(wp.getId() + (long)k, action);
    }

    @Test
    public void retryActionTest() throws Exception {
        String action = IntentOperation.Retry.toString();
        WorkflowProcess control = ProcessUtils.create("UserTaskTemplate", this.createdProcesses);
        WorkflowProcess wp = ProcessUtils.create("UserTaskTemplate", this.createdProcesses);
        ProcessUtils.sleepWhileActive(this.createdProcesses, timeoutMillisecs);
        ProcessUtils.assertStatus(wp.getId(), ProcessStatus.ERROR, 70000L);
        ProcessUtils.assertStatus(control.getId(), ProcessStatus.ERROR, 70000L);
        this.postAction("admin", "admin", wp.getId(), action, 202);
        logger.info((Object)("Taking Action " + action + " for WO #" + wp.getId()));
        ProcessUtils.assertStatus(wp.getId(), ProcessStatus.BUSY, timeoutMillisecs);
        ProcessUtils.assertStatus(control.getId(), ProcessStatus.ERROR, timeoutMillisecs);
        this.negativeActionTests(wp.getId(), action);
    }

    private void negativeActionTests(long topId, String action) throws Exception {
        this.postAction("admin", "admin", topId + 1000L, action, 500);
        this.postAction("admin", "admin", "abcd", action, 500);
        this.postAction("admin", "admin", topId, "jump", 500);
        this.postAction("admin", "admin", "", action, 405);
    }

    @Test
    public void getAlertUserTask() throws Exception {
        List<JsonNode> objectIds = this.getAlertObjectId("UserTaskTemplate", new HashMap<String, Object>(), 1);
        this.assertObjectIdWO(objectIds);
    }

    @Test
    public void getAlertFailure() throws Exception {
        List<JsonNode> objectIds = this.getAlertObjectId("FailureTemplate", new HashMap<String, Object>(), 1);
        this.assertObjectIdWO(objectIds);
    }

    @Test(enabled=false)
    public void getAlertTwoFailuresInBranch() throws Exception {
        List<JsonNode> objectIds = this.getAlertObjectId("TwoFailuresInBranchTemplate", new HashMap<String, Object>(), 1);
        this.assertObjectIdWO(objectIds);
    }

    @Test
    public void getAlertTwoUserTasksInBranch() throws Exception {
        List<JsonNode> objectIds = this.getAlertObjectId("TwoUserTasksInBranch", new HashMap<String, Object>(), 2);
        this.assertObjectIdWO(objectIds);
    }

    @Test
    public void getAlertFailureTemplateParent() throws Exception {
        List<JsonNode> objectIds = this.getAlertObjectId("FailureTemplateParent", new HashMap<String, Object>(), 2);
        this.assertObjectIdWO(objectIds);
    }

    @Test
    public void getAlertFailureTitleId() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String uniqueId = System.currentTimeMillis() + "";
        params.put("titleId", uniqueId);
        List<JsonNode> objectIds = this.getAlertObjectId("FailureTemplate", params, 1);
        uniqueId = "Title " + uniqueId;
        RecoverySupport.assertTrue((boolean)this.containsObjectId(objectIds, uniqueId), (String)("TitleId " + uniqueId + " is returned"));
    }

    @Test
    public void getAlertFailureTitleBrief() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String uniqueId = System.currentTimeMillis() + "";
        params.put("titleId", uniqueId);
        params.put("titleBrief", "titleBrief_" + uniqueId);
        List<JsonNode> objectIds = this.getAlertObjectId("FailureTemplate", params, 1);
        RecoverySupport.assertTrue((boolean)this.containsObjectId(objectIds, "titleBrief_" + uniqueId), (String)("titleBrief_" + uniqueId + " is returned"));
    }

    private void assertObjectIdWO(List<JsonNode> objectIds) {
        for (WorkflowProcess wp : this.createdProcesses) {
            RecoverySupport.assertTrue((boolean)this.containsObjectId(objectIds, "Work Order " + wp.getId()), (String)("Work Order " + wp.getId() + " is returned"));
        }
    }

    private List<JsonNode> getAlertObjectId(String template, HashMap<String, Object> params, int expectedSize) throws Exception {
        String startTime = this.getFormattedTime(System.currentTimeMillis());
        Thread.sleep(1000L);
        ProcessUtils.create(template, params, this.createdProcesses);
        ProcessUtils.sleepWhileActive(this.createdProcesses, timeoutMillisecs);
        Thread.sleep(1000L);
        String response = this.getAlarms("admin", "admin", startTime, 200);
        logger.info((Object)response);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode userData = mapper.readTree(response);
        RecoverySupport.assertEquals((int)userData.size(), (int)expectedSize, (String)"Number of alerts returned in json string");
        return userData.findValues("objectId");
    }

    private boolean containsObjectId(List<JsonNode> nodes, String objIdString) {
        for (JsonNode node : nodes) {
            if (node == null || !node.asText().equals(objIdString)) continue;
            logger.info((Object)(objIdString + " is returned"));
            return true;
        }
        return false;
    }

    private String getFormattedTime(long timeStamp) {
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeStamp));
        return time.replace(" ", "%20");
    }

    private String getAlarms(String usrname, String passwd, String startTime, int expectedResponseCode) throws Exception {
        String path = baseURI + alarmsGetPrefix + startTime;
        RestClient rc = new RestClient(usrname, passwd);
        String response = rc.getRestRequest(path);
        RecoverySupport.assertEquals((int)rc.getResponseCode(), (int)expectedResponseCode, (String)"get alarms response code");
        return response;
    }

    private String postAction(String usrname, String passwd, long processId, String action, int expectedResponseCode) throws Exception {
        return this.postAction(usrname, passwd, processId + "", action, expectedResponseCode);
    }

    private String postAction(String usrname, String passwd, String processId, String action, int expectedResponseCode) throws Exception {
        String path = baseURI + processPostPrefix + processId;
        String body = "{\"operation\" : \"" + action + "\"}";
        RestClient rc = new RestClient(usrname, passwd);
        String response = rc.postRestRequest(path, body);
        RecoverySupport.assertEquals((int)rc.getResponseCode(), (int)expectedResponseCode, (String)("post action response code for id=" + processId + " and action=" + action));
        return response;
    }
}

