/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.nodetype.branch.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.test.SequentialTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.util.HashMap;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BranchPauseCancel
extends SequentialTestBase {
    @BeforeClass
    public void beforeClass() throws Exception {
        ResourceUtils.setResourcesOffline("27");
    }

    @AfterClass
    public void afterClass() throws Exception {
        ResourceUtils.setResourcesOnline("27");
    }

    @Test
    public void testPauseAndCancelBranch() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timeout", 0);
        WorkflowProcess wp = this.run("branch-pause-cancel-template", params);
        long id = wp.getId();
        BranchPauseCancel.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 30000L, ProcessStatus.BRANCHED));
        ProcessUtils.pause(ProcessUtils.get(id));
        BranchPauseCancel.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 30000L, ProcessStatus.PAUSED));
        ProcessUtils.cancel(ProcessUtils.get(id));
        BranchPauseCancel.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 30000L, ProcessStatus.CANCELLED));
    }
}

