/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.rest.services.internal.ProcessesResource;
import com.tandbergtv.workflow.unit.test.RESTMockUtil;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class ProcessUnitTest {
    private static final String PROVIDER_ID = "providerId";
    private static final String NODE_NAME = "Designed to fail";
    private static final String ERROR_MESSAGE = "by design";
    private static final String TEMPLATE = "FailureTemplate";
    private static final String API_BASE_PATH = "/processes";
    private static final String FIELD_NAME = "processes";
    private static final Long TEMPLATE_ID = 28L;
    private static final int PROCESS_ID = 10;
    private static final String END_DATE = "endDate=";
    private static final String DETAIL = "detail=";
    private static final String BASE_URI = "http://localhost:7070";
    private IProcessSearchService mockSearchService;
    private ITemplateLoaderService mockTemplateService;
    private static RESTMockUtil restUtil;

    public ProcessUnitTest() {
        restUtil = new RESTMockUtil(ProcessesResource.class);
    }

    @Before
    public void setup() throws Exception {
        this.mockSearchService = (IProcessSearchService)Mockito.mock(WFSElasticSearchService.class);
        this.mockTemplateService = (ITemplateLoaderService)Mockito.mock(ITemplateLoaderService.class);
        PowerMockito.mockStatic(ServiceRegistry.class, (Class[])new Class[0]);
        ServiceRegistry mockRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)ServiceRegistry.getDefault()).thenReturn((Object)mockRegistry);
        Mockito.when((Object)mockRegistry.lookup(IProcessSearchService.class)).thenReturn((Object)this.mockSearchService);
        Mockito.when((Object)mockRegistry.lookup(ITemplateLoaderService.class)).thenReturn((Object)this.mockTemplateService);
    }

    @Test
    public void filterByTitleId() throws Exception {
        WorkflowTemplate mockTemplate = (WorkflowTemplate)Mockito.mock(WorkflowTemplate.class);
        Mockito.when((Object)this.mockSearchService.expressSearch((SearchCriteria)Matchers.any(SearchCriteria.class))).thenReturn(this.createSearchResults(1, 10, TEMPLATE));
        Mockito.when((Object)this.mockTemplateService.getTemplateByFullName(Matchers.anyString())).thenReturn((Object)mockTemplate);
        Mockito.when((Object)mockTemplate.getId()).thenReturn((Object)TEMPLATE_ID);
        List<Map<String, Object>> resources = restUtil.getResourcesList("/processes?detail=summary", FIELD_NAME);
        Assert.assertEquals((long)1L, (long)resources.size());
        Map<String, Object> map = resources.get(0);
        Assert.assertEquals((Object)"http://localhost:7070/processes/10", (Object)map.get("href"));
        Assert.assertTrue((boolean)map.get("template").toString().startsWith(TEMPLATE));
        Assert.assertEquals((Object)ProcessStatus.ERROR.name(), (Object)map.get("status"));
        Assert.assertEquals((Object)NODE_NAME, (Object)map.get("current"));
        Assert.assertEquals((Object)ErrorCategory.UNHANDLED_EXCEPTION.name(), (Object)map.get("errorType"));
        Assert.assertTrue((boolean)map.get("error").toString().endsWith(ERROR_MESSAGE));
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(API_BASE_PATH, headers).getStatus());
    }

    @Test
    public void testInvalidDetailParameter() throws Exception {
        String uri = "/processes?detail=wrongdetail";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "1");
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    @Test
    public void testInvalidEndDateParameter() throws Exception {
        String uri = "/processes?endDate=10-20a-2015";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "1");
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    private List<WFSearchResult> createSearchResults(int count, int processId, String template) {
        LinkedList<WFSearchResult> list = new LinkedList<WFSearchResult>();
        for (int i = 0; i < count; ++i) {
            list.add(this.createSearchResult(processId - i, template));
        }
        return list;
    }

    private WFSearchResult createSearchResult(int processId, String template) {
        WFSearchResult result = new WFSearchResult();
        result.setProcessId((long)processId);
        result.setPriority(ProcessPriority.valueOf((String)"P20").ordinal());
        result.setSuperProcessTokenId(0L);
        result.setHasFailedBranch(false);
        WFToken rootToken = new WFToken();
        rootToken.setTokenId(1L);
        rootToken.setProcessId(result.getProcessId());
        rootToken.setAdministrativeStatus(ProcessStatus.valueOf((String)"ERROR").ordinal());
        result.setToken(rootToken);
        rootToken.setOperationalStatus(ProcessStatus.valueOf((String)"ERROR").ordinal());
        rootToken.setNodeName(NODE_NAME);
        rootToken.setStartTime(new Date());
        rootToken.setEndTime(new Date());
        rootToken.setErrorType(ErrorCategory.UNHANDLED_EXCEPTION.ordinal());
        rootToken.setErrorComment(ERROR_MESSAGE);
        result.setToken(rootToken);
        WFVariable titleId = new WFVariable();
        titleId.setName("titleId");
        titleId.addValue("28");
        result.addVariable(titleId);
        WFVariable titleBrief = new WFVariable();
        titleBrief.setName("titleBrief");
        titleBrief.addValue("Title brief");
        result.addVariable(titleBrief);
        WFVariable ingestTemplate = new WFVariable();
        ingestTemplate.setName("ingestTemplate");
        ingestTemplate.addValue("CM");
        result.addVariable(ingestTemplate);
        WFVariable isActive = new WFVariable();
        isActive.setName("isActive");
        String isActiveStr = "true";
        isActive.addValue(isActiveStr);
        result.addVariable(isActive);
        result.setIsActive(isActiveStr);
        WFVariable templateId = new WFVariable();
        templateId.setName("templateId");
        templateId.addValue("142");
        result.addVariable(templateId);
        WFVariable providerId = new WFVariable();
        providerId.setName(PROVIDER_ID);
        providerId.addValue(PROVIDER_ID);
        result.addVariable(providerId);
        result.setProcessDefinitionName(template);
        result.setSearchResultCount(1L);
        result.setParentProcessId(0L);
        return result;
    }
}

