/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.rest.services.internal.ResourceGroupsResource;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.unit.test.RESTMockUtil;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class ResourceGroupsUnitTest {
    private static final String BASE_API_PATH = "/resourceGroups";
    private static final String NAME_API_PATH = "/resourceGroups/name";
    private static String RESOURCE_GROUP_ID = "1";
    private static String INVALID_DETAIL = "?detail=Dummy";
    private static String INVALID_START = "?start=-1";
    private static String INVALID_COUNT = "?count=-1";
    private static final String RESOURCE_GROUP_NAME = "testResourceGroup";
    private static RESTMockUtil restUtil;
    private static ResourceManagement resourceManagement;
    private static ServiceRegistry registry;

    public ResourceGroupsUnitTest() {
        restUtil = new RESTMockUtil(ResourceGroupsResource.class);
    }

    @Before
    public void setup() throws Exception {
        registry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        resourceManagement = (ResourceManagement)PowerMockito.mock(ResourceManagement.class);
        PowerMockito.mockStatic(ServiceRegistry.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceRegistry.getDefault()).thenReturn((Object)registry);
        Mockito.when((Object)registry.lookup(ResourceManagement.class)).thenReturn((Object)resourceManagement);
    }

    @Test
    public void getResourcesWhenNoVersionHeaderIsSent() throws Exception {
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources";
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, new HashMap<String, String>()).getStatus());
    }

    @Test
    public void getResourcesInvalidVersionHeader() throws Exception {
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    @Test
    public void getResourcesInvalidDetail() throws Exception {
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources" + INVALID_DETAIL;
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesInvalidStartParameter() throws Exception {
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources" + INVALID_START;
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesInvalidCountParameter() throws Exception {
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources" + INVALID_COUNT;
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesForNonExistingGroupId() throws Exception {
        Mockito.when((Object)resourceManagement.getResourceGroup(Long.valueOf(RESOURCE_GROUP_ID).longValue())).thenThrow(new Throwable[]{new FinderException()});
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources";
        Assert.assertEquals((long)404L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesByGroupIdThrowsException() throws Exception {
        Mockito.when((Object)resourceManagement.getResourcesByGroup(Long.valueOf(RESOURCE_GROUP_ID).longValue())).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID + "/resources";
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesByGroupNameWhenNoVersionHeaderIsSent() throws Exception {
        String uri = "/resourceGroups/name/testResourceGroup/resources";
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, new HashMap<String, String>()).getStatus());
    }

    @Test
    public void getResourcesByGroupNameInvalidVersionHeader() throws Exception {
        String uri = "/resourceGroups/name/testResourceGroup/resources";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    @Test
    public void getResourcesByGroupNameInvalidDetail() throws Exception {
        String uri = "/resourceGroups/name/testResourceGroup/resources" + INVALID_DETAIL;
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesByGroupNameInvalidStartParameter() throws Exception {
        String uri = "/resourceGroups/name/testResourceGroup/resources" + INVALID_START;
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesByGroupNameInvalidCountParameter() throws Exception {
        String uri = "/resourceGroups/name/testResourceGroup/resources" + INVALID_COUNT;
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourcesByGroupNameThrowsException() throws Exception {
        Mockito.when((Object)resourceManagement.getResourcesByGroupName(RESOURCE_GROUP_NAME)).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = "/resourceGroups/name/testResourceGroup/resources";
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourceGroupThrowsException() throws Exception {
        Mockito.when((Object)resourceManagement.getResourceGroup(Long.valueOf(RESOURCE_GROUP_ID).longValue())).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = "/resourceGroups/" + RESOURCE_GROUP_ID;
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void getResourceGroupsThrowsException() throws Exception {
        Mockito.when((Object)resourceManagement.getVisibleResourceGroups()).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = BASE_API_PATH;
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }
}

