/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.create;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.testng.annotations.Test;

public class VerifyCreatedProcess
extends NormalTestBase {
    private static final String VALID_STRING = "test";
    private static final String PARAM_LIST = "paramList";
    private static final String PARAM_DATE = "paramDate";
    private static final String PARAM_BOOLEAN = "paramBoolean";
    private static final String PARAM_INT = "paramInt";
    private static final String PARAM_STRING = "paramString";
    private static final String TEMPLATE = "blank-parameterized-template";
    private static final String TEMPLATE_EXTERNALPAGE_PARAMETER = "external-page-parameter-verification";
    private static final String EXTERNAL_PAGE = "_external_page";

    @Test
    public void testCreate() throws DriverException {
        WorkflowProcess wp = this.run("blank-template");
        VerifyCreatedProcess.assertNotNull((Object)wp);
    }

    @Test(expectedExceptions={DriverRuntimeException.class})
    public void testCreateWithInvalidIntVariable() throws DriverException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_STRING, VALID_STRING);
        params.put(PARAM_INT, "string");
        this.run(TEMPLATE, params);
    }

    @Test
    public void testCreateWithInvalidDateVariable() throws DriverException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_STRING, VALID_STRING);
        params.put(PARAM_DATE, "string");
        try {
            this.run(TEMPLATE, params);
            VerifyCreatedProcess.fail((String)"Should thrown exception.");
        }
        catch (DriverRuntimeException e) {
            VerifyCreatedProcess.assertTrue((boolean)(e.getCause().getCause() instanceof TypeConversionException));
        }
        params.put(PARAM_DATE, "01/01/2013");
        try {
            this.run(TEMPLATE, params);
            VerifyCreatedProcess.fail((String)"Should thrown exception.");
        }
        catch (DriverRuntimeException e) {
            VerifyCreatedProcess.assertTrue((boolean)(e.getCause().getCause() instanceof TypeConversionException));
        }
    }

    @Test(expectedExceptions={DriverRuntimeException.class})
    public void testCreateWithInvalidListVariable() throws DriverException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_STRING, VALID_STRING);
        params.put(PARAM_LIST, new HashMap());
        this.run(TEMPLATE, params);
    }

    @Test(expectedExceptions={DriverRuntimeException.class})
    public void testCreateWithoutRequiredParameter() throws DriverException {
        this.run(TEMPLATE);
    }

    @Test
    public void testCreateWithRequiredParameter() throws DriverException {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(TEMPLATE);
        Map<String, Object> params = this.fillRequiredParam(template);
        WorkflowProcess wp = this.run(TEMPLATE, params);
        VerifyCreatedProcess.assertNotNull((Object)wp);
    }

    @Test
    public void testCreateWithAllValidVariable() throws DriverException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_STRING, VALID_STRING);
        params.put(PARAM_INT, 1);
        params.put(PARAM_BOOLEAN, true);
        params.put(PARAM_DATE, "2013-01-01");
        ArrayList<String> l = new ArrayList<String>();
        l.add("1");
        params.put(PARAM_LIST, l);
        WorkflowProcess wp = this.run(TEMPLATE, params);
        VerifyCreatedProcess.assertNotNull((Object)wp);
    }

    @Test
    public void verifyVariableDataTypeValuesMatch() throws Exception {
        WorkflowProcess wp = this.run(TEMPLATE, this.addParameters());
        this.verifyProcessDetailsMatch(wp, TEMPLATE);
    }

    @Test
    public void verifyVariableDataTypeValuesCanBeOverriden() throws Exception {
        WorkflowProcess wp = this.run("variable-default-value-assigned-template", this.addParameters());
        this.verifyProcessDetailsMatch(wp, "variable-default-value-assigned-template");
    }

    @Test
    public void verifyBooleanVariable() throws Exception {
        WorkflowProcess wp = this.run(TEMPLATE_EXTERNALPAGE_PARAMETER);
        VerifyCreatedProcess.assertTrue((boolean)ProcessUtils.sleepUntilStatus(wp.getId(), 60000L, ProcessStatus.BUSY));
        long id = wp.getId();
        Thread.sleep(5000L);
        wp = ProcessUtils.get(id);
        TaskInstance task = ProcessUtils.getTaskInstance(wp);
        VerifyCreatedProcess.assertNotNull((Object)task);
        List variables = task.getTask().getTaskController().getVariableAccesses();
        for (TaskVariable variable : variables) {
            String name = variable.getVariableName();
            if (!EXTERNAL_PAGE.equals(name) || variable.getDatatype() != Datatype.BOOLEAN) continue;
            VerifyCreatedProcess.assertTrue((boolean)(task.getVariable(variable.getVariableName()) instanceof Boolean));
            break;
        }
    }

    private Map<String, Object> addParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_STRING, VALID_STRING);
        params.put(PARAM_INT, 1);
        params.put(PARAM_BOOLEAN, true);
        params.put(PARAM_DATE, "2013-01-01");
        params.put(PARAM_LIST, this.getListParameters());
        return params;
    }

    private ArrayList<String> getListParameters() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("1");
        l.add("2");
        l.add("3");
        return l;
    }

    private Date getDate() throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd").parse("2013-01-01");
    }

    private void verifyProcessDetailsMatch(WorkflowProcess wp, String template) throws ParseException {
        VerifyCreatedProcess.assertEquals((Object)wp.getPriority(), (Object)ProcessPriority.P10);
        VerifyCreatedProcess.assertEquals((String)wp.getProcessDefinition().getName(), (String)template);
        VerifyCreatedProcess.assertEquals((Object)wp.getContextInstance().getVariable(PARAM_STRING), (Object)VALID_STRING);
        VerifyCreatedProcess.assertEquals((Object)wp.getContextInstance().getVariable(PARAM_INT), (Object)1);
        VerifyCreatedProcess.assertEquals((Object)wp.getContextInstance().getVariable(PARAM_BOOLEAN), (Object)true);
        VerifyCreatedProcess.assertEquals((Object)wp.getContextInstance().getVariable(PARAM_DATE), (Object)this.getDate());
        VerifyCreatedProcess.assertEquals((Object)wp.getContextInstance().getVariable(PARAM_LIST), this.getListParameters());
    }

    private Map<String, Object> fillRequiredParam(WorkflowTemplate template) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (TaskVariable v : template.getStartTaskVariables()) {
            if (!v.isRequired()) continue;
            ArrayList<String> value = v.initialValue();
            switch (v.getDatatype()) {
                case BOOLEAN: {
                    value = Boolean.TRUE;
                    break;
                }
                case DATE: {
                    value = new Date();
                    break;
                }
                case INT: {
                    value = Integer.MAX_VALUE;
                    break;
                }
                case LIST: {
                    ArrayList<String> l = new ArrayList<String>();
                    l.add("1");
                    value = l;
                    break;
                }
                default: {
                    value = UUID.randomUUID().toString();
                }
            }
            params.put(v.getVariableName(), value);
        }
        return params;
    }
}

