/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.rest.services.internal.ComponentResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Test(groups={"normal"})
public class ComponentResourceTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/component";
    private static final String MODULE_NODE = "//Modules/Module";
    private static final String USER_TASKS_PERMISSION_NODE = "//Module[Name='UserTasks']/Permissions/Permission";
    private static final String USER_TASK_MODULE_NODE = "//Module[Name='UserTasks']";
    private static final String PORTLET_NODE = "//Portlets/Portlet";
    private static final String MENU_ITEM_NODE = "//MenuItem";
    private static final String USER_TASK_MENU_ITEM = "//MenuItem[Name='User Tasks']";
    private static final String PERMISSION_NODE = "/Authorization/Permission";
    private static final String DISPLAY_NAME_NODE = "/DisplayName";
    private static final String MAPPINGS = "/Mappings";
    private static final String MODULE_NAME_ATTRIBUTE = "/@moduleName";
    private static final String USER_TASKS = "UserTasks";

    public ComponentResourceTest() {
        super(ComponentResource.class);
    }

    @Test
    public void testComponentForModulesPortletsAndMenuItems() throws Exception {
        MockHttpResponse response = this.execute(BASE_API_PATH, new HashMap<String, String>(), MockRequestType.GET);
        ComponentResourceTest.assertEquals((int)response.getStatus(), (int)200);
        Document responseDoc = RESTUtil.loadXml(response.getContentAsString());
        XPath xpath = XPathFactory.newInstance().newXPath();
        this.verifyModules(responseDoc, xpath);
        this.verifyPortlets(responseDoc, xpath);
        this.verifyMenuItems(responseDoc, xpath);
    }

    private void verifyModules(Document responseDoc, XPath xpath) throws XPathExpressionException {
        NodeList modulesList = (NodeList)xpath.evaluate(MODULE_NODE, responseDoc, XPathConstants.NODESET);
        ComponentResourceTest.assertEquals((int)modulesList.getLength(), (int)6);
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//Module[Name='UserTasks']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"User Tasks");
        this.verifyPermissionForUserTaskModule(responseDoc, xpath);
    }

    private void verifyPermissionForUserTaskModule(Document responseDoc, XPath xpath) throws XPathExpressionException {
        NodeList permissionsList = (NodeList)xpath.evaluate(USER_TASKS_PERMISSION_NODE, responseDoc, XPathConstants.NODESET);
        ComponentResourceTest.assertEquals((int)permissionsList.getLength(), (int)5);
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//Module[Name='UserTasks']/Permissions/Permission[Name='PerformTask']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"Perform Task");
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//Module[Name='UserTasks']/Permissions/Permission[Name='PerformOthersTasks']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"Perform Others Tasks");
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//Module[Name='UserTasks']/Permissions/Permission[Name='OverrideExternalTasks']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"Override External Tasks");
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//Module[Name='UserTasks']/Permissions/Permission[Name='AssignTask']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"Assign Task");
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//Module[Name='UserTasks']/Permissions/Permission[Name='AssignTaskToOthers']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"Assign Task To Others");
    }

    private void verifyMenuItems(Document responseDoc, XPath xpath) throws XPathExpressionException {
        NodeList menuItemsList = (NodeList)xpath.evaluate(MENU_ITEM_NODE, responseDoc, XPathConstants.NODESET);
        ComponentResourceTest.assertEquals((int)menuItemsList.getLength(), (int)7);
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//MenuItem[Name='User Tasks']/DisplayName", responseDoc, XPathConstants.STRING), (Object)"User Tasks");
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//MenuItem[Name='User Tasks']/Mappings", responseDoc, XPathConstants.STRING), (Object)"userTasksAction.do?method=getUserTasks");
        NodeList permissions = (NodeList)xpath.evaluate("//MenuItem[Name='User Tasks']/Authorization/Permission", responseDoc, XPathConstants.NODESET);
        ComponentResourceTest.assertEquals((int)permissions.getLength(), (int)1);
        ComponentResourceTest.assertEquals((Object)xpath.evaluate("//MenuItem[Name='User Tasks']/Authorization/Permission[@permissionName='PerformTask']/@moduleName", responseDoc, XPathConstants.STRING), (Object)USER_TASKS);
    }

    private void verifyPortlets(Document responseDoc, XPath xpath) throws XPathExpressionException {
        NodeList portletList = (NodeList)xpath.evaluate(PORTLET_NODE, responseDoc, XPathConstants.NODESET);
        ComponentResourceTest.assertEquals((int)portletList.getLength(), (int)0);
    }
}

