/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.HashMap;
import org.testng.annotations.Test;

public class VerifyDifferentErrorTypesForProcess
extends NormalTestBase {
    @Test
    public void testCustomActionHandlerExceptionErrorDetails() throws Exception {
        WorkflowProcess wp = this.createProcess("FailureTemplate");
        VerifyDifferentErrorTypesForProcess.assertEquals((Object)wp.getRootToken().getErrorDetails().getCategory(), (Object)ErrorCategory.UNHANDLED_EXCEPTION);
        VerifyDifferentErrorTypesForProcess.assertEquals((String)wp.getRootToken().getErrorDetails().getMessage(), (String)"Forcing execution to fail: by design");
    }

    @Test
    public void testAssignNodeNullValueErrorDetails() throws Exception {
        WorkflowProcess wp = this.createProcess("exception-assignnode-null-value-template");
        VerifyDifferentErrorTypesForProcess.assertEquals((Object)wp.getRootToken().getErrorDetails().getCategory(), (Object)ErrorCategory.UNHANDLED_EXCEPTION);
        VerifyDifferentErrorTypesForProcess.assertEquals((String)wp.getRootToken().getErrorDetails().getMessage(), (String)"Sourced file: inline evaluation of: ``var2.get(1);'' : Attempt to resolve method: get() on undefined variable or class name: var2");
    }

    @Test
    public void testStackOverflowErrorDetails() throws Exception {
        WorkflowProcess wp = this.createProcess("stack-overflow-template");
        VerifyDifferentErrorTypesForProcess.assertEquals((Object)wp.getRootToken().getErrorDetails().getCategory(), (Object)ErrorCategory.INFINITE_LOOP);
        VerifyDifferentErrorTypesForProcess.assertEquals((String)wp.getRootToken().getErrorDetails().getMessage(), (String)"Loop exceeded iteration limit");
    }

    @Test
    public void testTimeOutErrorDetails() throws Exception {
        WorkflowProcess wp = this.createProcess("exception-timeout-template");
        VerifyDifferentErrorTypesForProcess.assertEquals((Object)wp.getRootToken().getErrorDetails().getCategory(), (Object)ErrorCategory.TIMEOUT);
        VerifyDifferentErrorTypesForProcess.assertEquals((String)wp.getRootToken().getErrorDetails().getMessage(), (String)"Timed out at Sleep");
    }

    @Test
    public void testMessageNack() throws Exception {
        WorkflowProcess wp = this.createProcess("message-nack-template");
        VerifyDifferentErrorTypesForProcess.assertEquals((Object)wp.getRootToken().getErrorDetails().getCategory(), (Object)ErrorCategory.NACK);
    }

    private WorkflowProcess createProcess(String templateName) throws Exception {
        WorkflowProcess wp = this.run(templateName, new HashMap<String, Object>());
        long id = wp.getId();
        ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.ERROR);
        wp = ProcessUtils.get(id);
        VerifyDifferentErrorTypesForProcess.assertEquals((Object)wp.getRootToken().getStatus(), (Object)ProcessStatus.ERROR);
        return wp;
    }
}

