/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.nodetype.subprocess.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class SubProcessTest
extends NormalTestBase {
    @Test
    public void testSubprocessChangeStatus() throws Exception {
        WorkflowProcess wp = this.run("subprocess-parent-template", new HashMap<String, Object>());
        long id = wp.getId();
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        SubProcessTest.assertEquals((int)ProcessUtils.get(id).getSubProcessInstances().size(), (int)1);
        WorkflowProcess child = (WorkflowProcess)ProcessUtils.get(id).getSubProcessInstances().iterator().next();
        SubProcessTest.assertEquals((boolean)child.getCanBePaused(), (boolean)false);
        SubProcessTest.assertEquals((boolean)child.getCanBeResumed(), (boolean)false);
        SubProcessTest.assertEquals((boolean)child.getCanBeCancelled(), (boolean)false);
        SubProcessTest.assertEquals((boolean)child.getCanBeRestarted(), (boolean)false);
    }

    @Test
    public void testParentBusyDuringChildExecution() throws Exception {
        WorkflowProcess wp = this.run("subprocess-parent-template");
        long id = wp.getId();
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        SubProcessTest.assertEquals((int)ProcessUtils.get(id).getSubProcessInstances().size(), (int)1);
        long childId = ((WorkflowProcess)ProcessUtils.get(id).getSubProcessInstances().iterator().next()).getId();
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(childId, 10000L, ProcessStatus.BUSY));
    }

    @Test
    public void testErrorSubprocessStatus() throws Exception {
        WorkflowProcess wp = this.run("subprocess-error-parent-template");
        long id = wp.getId();
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.ERROR));
        WorkflowProcess child = ProcessUtils.get(id).getRootToken().getSubProcessInstance();
        SubProcessTest.assertNotNull((Object)child);
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(child.getId(), 5000L, ProcessStatus.ERROR));
    }

    @Test
    public void testPauseSubprocess() throws Exception {
        WorkflowProcess wp = this.run("subprocess-parent-template");
        long id = wp.getId();
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        SubProcessTest.assertEquals((int)ProcessUtils.get(id).getSubProcessInstances().size(), (int)1);
        long childId = ((WorkflowProcess)ProcessUtils.get(id).getSubProcessInstances().iterator().next()).getId();
        ProcessUtils.pause(ProcessUtils.get(id));
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.PAUSED));
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(childId, 10000L, ProcessStatus.PAUSED));
        ProcessUtils.resume(ProcessUtils.get(id));
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(childId, 60000L));
        SubProcessTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 1000L));
    }
}

