/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.test.StandaloneTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RecoveryStartsOnLastReachedNode
extends StandaloneTestBase {
    private static final String LIST_VARIABLE_NAME = "manualVariableList";
    private static final String VALUE_FIRST = "Wrong Manual Task";
    private static final String VALUE_SECOND = "Right Manual Task";
    private static final String VARIABLE_NAME = "loopManualVariable";

    @BeforeClass
    public void beforeClass() throws Exception {
        this.start();
        Thread.sleep(20000L);
    }

    @AfterClass
    public void afterClass() {
        this.stop();
    }

    @Test
    private void testRestartOnLastRunNode() throws Exception {
        WorkflowProcess wp = this.run("loop-manual-task-template", this.getParameters());
        RecoveryStartsOnLastReachedNode.assertNotNull((Object)wp);
        long id = wp.getId();
        RecoveryStartsOnLastReachedNode.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 10000L, ProcessStatus.BUSY));
        Thread.sleep(5000L);
        wp = ProcessUtils.get(id);
        RecoveryStartsOnLastReachedNode.assertNotNull((Object)ProcessUtils.getTaskInstance(wp));
        ProcessUtils.performManualTask(wp);
        Thread.sleep(30000L);
        this.restartNodeRunningThisProcess(ProcessUtils.get(wp.getId()));
        wp = ProcessUtils.get(id);
        TaskInstance task = ProcessUtils.getTaskInstance(wp);
        RecoveryStartsOnLastReachedNode.assertNotNull((Object)task);
        RecoveryStartsOnLastReachedNode.assertEquals((Object)task.getVariable(VARIABLE_NAME), (Object)VALUE_SECOND);
    }

    private Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(LIST_VARIABLE_NAME, new ArrayList(Lists.newArrayList((Object[])new String[]{VALUE_FIRST, VALUE_SECOND})));
        return params;
    }
}

