/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.rest.services.internal.ResourceGroupsResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class ResourceGroupsResourceTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/resourceGroups/";
    private static ResourceGroup resourceGroup;

    public ResourceGroupsResourceTest() {
        super(ResourceGroupsResource.class);
    }

    @BeforeClass
    public void getResourceGroup() {
        resourceGroup = ResourceUtils.getResourceGroupsByResourceTypeSystemId("04").iterator().next();
    }

    @Test
    public void testWhenNoVersionHeaderIsSent() throws Exception {
        String uri = BASE_API_PATH + resourceGroup.getId();
        MockHttpResponse response = this.execute(uri, new HashMap<String, String>(), MockRequestType.GET);
        ResourceGroupsResourceTest.assertEquals((int)response.getStatus(), (int)412);
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        String uri = BASE_API_PATH + resourceGroup.getId();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        MockHttpResponse response = this.execute(uri, headers, MockRequestType.GET);
        ResourceGroupsResourceTest.assertEquals((int)response.getStatus(), (int)412);
    }

    @Test
    public void testResourceGroupNotFound() throws Exception {
        String uri = "/resourceGroups/0";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsResourceTest.assertEquals((int)response.getStatus(), (int)404);
    }

    private void verifyResponseParameters(Map<String, Object> responseMap, String path) throws JsonParseException, JsonMappingException, IOException, ResourceManagementException {
        ResourceGroupsResourceTest.assertEquals((String)responseMap.get("id").toString(), (String)String.valueOf(resourceGroup.getId()));
        ResourceGroupsResourceTest.assertEquals((String)responseMap.get("name").toString(), (String)resourceGroup.getName());
        ResourceGroupsResourceTest.assertEquals((Object)responseMap.get("href"), (Object)("http://localhost:8081/resourceGroups/" + resourceGroup.getId()));
        ResourceGroupsResourceTest.assertEquals((String)responseMap.get("queueSize").toString(), (String)String.valueOf(resourceGroup.getQueue().size()));
        ResourceGroupsResourceTest.assertEquals((String)responseMap.get("isInternallyAcquired").toString(), (String)String.valueOf(resourceGroup.isInternallyAcquired()));
        ResourceGroupsResourceTest.assertEquals((String)responseMap.get("isVisible").toString(), (String)String.valueOf(resourceGroup.isVisible()));
        ResourceGroupsResourceTest.assertEquals((String)responseMap.get("resourceTypeName").toString(), (String)resourceGroup.getResourceType().getName());
    }
}

