/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SearchUtils {
    private SearchUtils() {
    }

    public static List<WorkflowProcess> searchByTemplateAndStatus(String template, ProcessStatus status) {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        String simpleDate = new SimpleDateFormat("yyyy-MM-dd").format(date);
        SearchCriteria criteria = new SearchCriteria();
        ListParameter parameter = new ListParameter("operationalStatus", SearchType.PROCESSSTATUS);
        parameter.addValues(new Object[]{status});
        criteria.addParameter((SearchParameterBase)parameter);
        ListParameter parameter2 = new ListParameter("processDefinition.name", SearchType.STRING);
        parameter2.addValues(new Object[]{template});
        criteria.addParameter((SearchParameterBase)parameter2);
        RangeParameter rangeParam = new RangeParameter("startTime", SearchType.DATE, false);
        rangeParam.setFrom(simpleDate);
        criteria.addParameter((SearchParameterBase)rangeParam);
        List results = ((IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class)).expressSearch(criteria);
        ArrayList<WorkflowProcess> processesOfState = new ArrayList<WorkflowProcess>();
        for (WFSearchResult result : results) {
            processesOfState.add(ProcessUtils.get(result.getProcessId()));
        }
        return processesOfState;
    }
}

