/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.rest.services.internal.TasksResource;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.unit.test.RESTMockUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class TaskResourceUnitTest {
    private static final String API_PATH = "/tasks/";
    private static final String CONNECTION_STRING_BASE = "testConnectionString";
    private static final String RESOURCE_NAME = "testResource";
    private static final long HEARTBEAT_FREQUENCY = 10L;
    private static final boolean IGNORE_TIMEOUT = false;
    private static final String RESOURCE_TYPE = "testResourceType";
    private static final String RESOURCE_GROUP1_NAME = "group1";
    private static final String RESOURCE_GROUP2_NAME = "group2";
    private static final int MAX_CONCURRENT_USERS = 3;
    private static final Object TASKS_FIELD_NAME = "tasks";
    private static final String ADMIN_USER = "admin";
    private ResourceManagement mockResourceManagement;
    private IPersistenceService mockPersistService;
    private static RESTMockUtil restUtil;
    private static ServiceRegistry registry;

    public TaskResourceUnitTest() {
        restUtil = new RESTMockUtil(TasksResource.class);
    }

    @Before
    public void setup() throws Exception {
        registry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        this.mockResourceManagement = (ResourceManagement)Mockito.mock(ResourceManagement.class);
        this.mockPersistService = (IPersistenceService)Mockito.mock(IPersistenceService.class);
        PowerMockito.mockStatic(ServiceRegistry.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceRegistry.getDefault()).thenReturn((Object)registry);
        Mockito.when((Object)registry.lookup(ResourceManagement.class)).thenReturn((Object)this.mockResourceManagement);
        Mockito.when((Object)registry.lookup(IPersistenceService.class)).thenReturn((Object)this.mockPersistService);
    }

    @Test
    public void validateResponse() throws Exception {
        this.initializeTest(1, false);
        String uri = "/tasks/admin";
        Map<String, Object> responseMap = restUtil.getResponseMap(uri);
        Assert.assertEquals((Object)responseMap.get("count").toString(), (Object)"10");
        Assert.assertEquals((Object)responseMap.get("start").toString(), (Object)"0");
        List tasks = (List)responseMap.get(TASKS_FIELD_NAME);
        for (Map task : tasks) {
            Assert.assertTrue((task.get("id") != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTaskTrimed() throws Exception {
        this.initializeTest(15, false);
        String uri = "/tasks/admin";
        Map<String, Object> responseMap = restUtil.getResponseMap(uri);
        List tasks = (List)responseMap.get(TASKS_FIELD_NAME);
        Assert.assertEquals((long)10L, (long)tasks.size());
    }

    @Test
    public void testNullTaskInstance() throws Exception {
        this.initializeTest(1, true);
        String uri = "/tasks/admin";
        Map<String, Object> responseMap = restUtil.getResponseMap(uri);
        List tasks = (List)responseMap.get(TASKS_FIELD_NAME);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        String uri = "/tasks/admin";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    @Test
    public void testNoResourceForUser() throws Exception {
        Mockito.when((Object)this.mockResourceManagement.getResourceByUser(ADMIN_USER)).thenReturn(null);
        String uri = "/tasks/admin";
        Assert.assertEquals((long)404L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    private void initializeTest(int size, boolean isTaskInstanceNull) throws Exception {
        Resource resource = this.initializeResource(size);
        WorkflowProcess mockProcess = (WorkflowProcess)Mockito.mock(WorkflowProcess.class);
        CustomToken mockToken = (CustomToken)Mockito.mock(CustomToken.class);
        TaskMgmtInstance mockTaskMgmtInstance = (TaskMgmtInstance)Mockito.mock(TaskMgmtInstance.class);
        ContextInstance mockContext = (ContextInstance)Mockito.mock(ContextInstance.class);
        ResourceGroup group = new ResourceGroup(1L);
        group.setName("Test Resource Group");
        LinkedList<TaskInstance> taskInstances = new LinkedList<TaskInstance>();
        for (int i = 1; i <= size; ++i) {
            TaskInstance taskInstance = new TaskInstance();
            taskInstance.setId((long)i);
            taskInstances.add(taskInstance);
        }
        if (isTaskInstanceNull) {
            taskInstances = null;
        }
        Node node = new Node("Test Node");
        WorkflowTemplate template = new WorkflowTemplate("Test Template");
        Mockito.when((Object)this.mockResourceManagement.getResourceByUser(ADMIN_USER)).thenReturn((Object)resource);
        Mockito.when((Object)this.mockResourceManagement.getResourceGroup(Matchers.anyLong())).thenReturn((Object)group);
        Mockito.when((Object)this.mockPersistService.get((Serializable)Long.valueOf(Matchers.anyLong()))).thenReturn((Object)mockProcess);
        Mockito.when((Object)mockProcess.findToken(Matchers.anyLong())).thenReturn((Object)mockToken);
        Mockito.when((Object)mockProcess.getTaskMgmtInstance()).thenReturn((Object)mockTaskMgmtInstance);
        Mockito.when((Object)mockTaskMgmtInstance.getTaskInstances()).thenReturn(taskInstances);
        Mockito.when((Object)mockToken.getNode()).thenReturn((Object)node);
        Mockito.when((Object)mockToken.getProcessInstance()).thenReturn((Object)mockProcess);
        Mockito.when((Object)mockProcess.getContextInstance()).thenReturn((Object)mockContext);
        Mockito.when((Object)mockProcess.getProcessDefinition()).thenReturn((Object)template);
        Mockito.when((Object)mockContext.getVariable("titleId")).thenReturn((Object)"1");
        Mockito.when((Object)mockContext.getVariable("providerId")).thenReturn((Object)"WON");
    }

    private Resource initializeResource(int size) throws DataOperationException, ValidationException {
        ResourceType resType = new ResourceType();
        resType.setName(RESOURCE_TYPE);
        ResourceGroup resGrp1 = new ResourceGroup();
        ResourceGroup resGrp2 = new ResourceGroup();
        resGrp1.setName(RESOURCE_GROUP1_NAME);
        resGrp2.setName(RESOURCE_GROUP2_NAME);
        HashSet<ResourceGroup> groups = new HashSet<ResourceGroup>();
        groups.add(resGrp1);
        groups.add(resGrp2);
        Resource resource = new Resource();
        resource.setResourceGroups(groups);
        resource.setName(RESOURCE_NAME);
        resource.setConnectionString(CONNECTION_STRING_BASE);
        resource.setMaxConcurrentUsers(3);
        resource.setHeartbeatFrequency(Long.valueOf(10L));
        resource.setResourceType(resType);
        resource.setIgnoreTimeout(false);
        HashSet<ResourceUser> users = new HashSet<ResourceUser>();
        for (int i = 1; i <= size; ++i) {
            ResourceConsumerKey key = new ResourceConsumerKey((long)i, (long)i, new Long(i), "", ProcessPriority.P10);
            ResourceUser user = new ResourceUser(key);
            users.add(user);
        }
        resource.setUsers(users);
        return resource;
    }
}

